package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 任务记录对象 t_task_record
 *
 * @author zehong
 * @date 2023-11-06
 */
public class TTaskRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long taskRecordId;

    /** 操作人id */
    @Excel(name = "操作人id")
    private Long operator;

    /** 关联主键  对应到每一个表中 */
    @Excel(name = "关联主键  对应到每一个表中")
    private Long processesRelationId;

    /** 工序  0气瓶充装  1气瓶配送 2入户安检 3气瓶回收 4扫码用车 5用户录入 */
    @Excel(name = "工序  0气瓶充装  1气瓶配送 2入户安检 3气瓶回收 4扫码用车 5用户录入")
    private String processesName;

    /** 是否删除 0未删除 1删除 */
    @Excel(name = "是否删除 0未删除 1删除")
    private String isDel;

    /**
     * 气瓶编号
     */
    private String bottleCode;

    public void setTaskRecordId(Long taskRecordId)
    {
        this.taskRecordId = taskRecordId;
    }

    public Long getTaskRecordId()
    {
        return taskRecordId;
    }
    public void setOperator(Long operator)
    {
        this.operator = operator;
    }

    public Long getOperator()
    {
        return operator;
    }
    public void setProcessesRelationId(Long processesRelationId)
    {
        this.processesRelationId = processesRelationId;
    }

    public Long getProcessesRelationId()
    {
        return processesRelationId;
    }
    public void setProcessesName(String processesName)
    {
        this.processesName = processesName;
    }

    public String getProcessesName()
    {
        return processesName;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("taskRecordId", getTaskRecordId())
            .append("operator", getOperator())
            .append("processesRelationId", getProcessesRelationId())
            .append("processesName", getProcessesName())
            .append("createTime", getCreateTime())
            .append("isDel", getIsDel())
            .toString();
    }
}
