package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 重大危险源监管对象 t_sup_major_hazard
 * 
 * @author zehong
 * @date 2024-04-19
 */
public class TSupMajorHazard extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** ID */
    private Long fHazardId;

    /** 名称 */
    @Excel(name = "名称")
    private String fName;

    /** 责任人 */
    @Excel(name = "责任人")
    private String fResPer;

    /** 电话 */
    @Excel(name = "电话")
    private String fPhone;

    /** 安全评估信息 */
    private String fEvaInfor;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 分级情况 */
    @Excel(name = "分级情况")
    private String fLevel;

    public String getBeyondEnterpriseId() {
        return beyondEnterpriseId;
    }

    public void setBeyondEnterpriseId(String beyondEnterpriseId) {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    /** 权属单位 */
    private String beyondEnterpriseId;

    /** 创建时间 */
    private Date fCreateTime;

    /** 修改时间 */
    private Date fUpdateTime;

    /** 是否删除(0正常，1删除) */
    private String fIsDel;

    /** 备注 */
    private String fRemarks;

    public void setfHazardId(Long fHazardId) 
    {
        this.fHazardId = fHazardId;
    }

    public Long getfHazardId() 
    {
        return fHazardId;
    }
    public void setfName(String fName) 
    {
        this.fName = fName;
    }

    public String getfName() 
    {
        return fName;
    }
    public void setfResPer(String fResPer) 
    {
        this.fResPer = fResPer;
    }

    public String getfResPer() 
    {
        return fResPer;
    }
    public void setfPhone(String fPhone) 
    {
        this.fPhone = fPhone;
    }

    public String getfPhone() 
    {
        return fPhone;
    }
    public void setfEvaInfor(String fEvaInfor) 
    {
        this.fEvaInfor = fEvaInfor;
    }

    public String getfEvaInfor() 
    {
        return fEvaInfor;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setfLevel(String fLevel)
    {
        this.fLevel = fLevel;
    }

    public String getfLevel()
    {
        return fLevel;
    }
    public void setfCreateTime(Date fCreateTime) 
    {
        this.fCreateTime = fCreateTime;
    }

    public Date getfCreateTime() 
    {
        return fCreateTime;
    }
    public void setfUpdateTime(Date fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public Date getfUpdateTime() 
    {
        return fUpdateTime;
    }
    public void setfIsDel(String fIsDel) 
    {
        this.fIsDel = fIsDel;
    }

    public String getfIsDel() 
    {
        return fIsDel;
    }
    public void setfRemarks(String fRemarks) 
    {
        this.fRemarks = fRemarks;
    }

    public String getfRemarks() 
    {
        return fRemarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fHazardId", getfHazardId())
            .append("fName", getfName())
            .append("fResPer", getfResPer())
            .append("fPhone", getfPhone())
            .append("fEvaInfor", getfEvaInfor())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("fLevel", getfLevel())
            .append("fCreateTime", getfCreateTime())
            .append("fUpdateTime", getfUpdateTime())
            .append("fIsDel", getfIsDel())
            .append("fRemarks", getfRemarks())
            .toString();
    }
}
