package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 供需平衡-停气监管对象 t_sup_bal_stop_sup
 * 
 * @author zehong
 * @date 2024-06-21
 */
public class TSupBalStopSup extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fGasStopId;

    /** 企业uuid */
    private String fCompanyInfoId;

    //@Excel(name = "企业名称")
    private String enterpriseName;

    /** 停气开始日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "停气开始日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fStartDate;

    /** 停气结束日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "停气结束日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fEndDate;

    /** 停气类型 */
    @Excel(name = "停气类型",dictType = "t_stop_type")
    private String fStopType;

    /** 影响用户 */
    @Excel(name = "影响用户")
    private Long fInfluenceCus;

    /** 停气原因 */
    @Excel(name = "停气原因")
    private String fStopReason;

    /** 停气范围 */
    @Excel(name = "停气范围")
    private String fStopRange;

    /** 停气进度 */
    @Excel(name = "停气进度",dictType = "t_stop_progress")
    private String fStopProgress;

    /** 恢复供气时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "恢复供气时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date fRecoveryGasTime;

    /** 上报状态 0-未上报，1-已上报 */
    @Excel(name = "上报状态",readConverterExp = " 0=未上报,1=已上报")
    private String fRepStatus;

    /**
     * 企业端上传时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "上报时间", width = 30)
    private String entRepTime;

    /** 停气区域 */
    @Excel(name = "停气区域")
    private String fGasStopArea;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    @Excel(name = "上报省厅状态",readConverterExp = "0=未上报,1=已上报")
    private String fGovUploadStatus;

    /** 政府端上报时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "上报省厅时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm")
    private Date fGovUploadTime;

    public void setfGasStopId(Long fGasStopId) 
    {
        this.fGasStopId = fGasStopId;
    }

    public Long getfGasStopId() 
    {
        return fGasStopId;
    }
    public void setfCompanyInfoId(String fCompanyInfoId) 
    {
        this.fCompanyInfoId = fCompanyInfoId;
    }

    public String getfCompanyInfoId() 
    {
        return fCompanyInfoId;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public void setfStartDate(Date fStartDate)
    {
        this.fStartDate = fStartDate;
    }

    public Date getfStartDate() 
    {
        return fStartDate;
    }
    public void setfEndDate(Date fEndDate) 
    {
        this.fEndDate = fEndDate;
    }

    public Date getfEndDate() 
    {
        return fEndDate;
    }
    public void setfStopType(String fStopType) 
    {
        this.fStopType = fStopType;
    }

    public String getfStopType() 
    {
        return fStopType;
    }
    public void setfInfluenceCus(Long fInfluenceCus) 
    {
        this.fInfluenceCus = fInfluenceCus;
    }

    public Long getfInfluenceCus() 
    {
        return fInfluenceCus;
    }
    public void setfStopReason(String fStopReason) 
    {
        this.fStopReason = fStopReason;
    }

    public String getfStopReason() 
    {
        return fStopReason;
    }
    public void setfStopRange(String fStopRange) 
    {
        this.fStopRange = fStopRange;
    }

    public String getfStopRange() 
    {
        return fStopRange;
    }
    public void setfStopProgress(String fStopProgress) 
    {
        this.fStopProgress = fStopProgress;
    }

    public String getfStopProgress() 
    {
        return fStopProgress;
    }
    public void setfRecoveryGasTime(Date fRecoveryGasTime) 
    {
        this.fRecoveryGasTime = fRecoveryGasTime;
    }

    public Date getfRecoveryGasTime() 
    {
        return fRecoveryGasTime;
    }
    public void setfRepStatus(String fRepStatus) 
    {
        this.fRepStatus = fRepStatus;
    }

    public String getfRepStatus() 
    {
        return fRepStatus;
    }
    public void setfGasStopArea(String fGasStopArea) 
    {
        this.fGasStopArea = fGasStopArea;
    }

    public String getfGasStopArea() 
    {
        return fGasStopArea;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    public String getfGovUploadStatus() {
        return fGovUploadStatus;
    }

    public void setfGovUploadStatus(String fGovUploadStatus) {
        this.fGovUploadStatus = fGovUploadStatus;
    }

    public Date getfGovUploadTime() {
        return fGovUploadTime;
    }

    public void setfGovUploadTime(Date fGovUploadTime) {
        this.fGovUploadTime = fGovUploadTime;
    }

    public String getEntRepTime() {
        return entRepTime;
    }

    public void setEntRepTime(String entRepTime) {
        this.entRepTime = entRepTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fGasStopId", getfGasStopId())
            .append("fCompanyInfoId", getfCompanyInfoId())
            .append("fStartDate", getfStartDate())
            .append("fEndDate", getfEndDate())
            .append("fStopType", getfStopType())
            .append("fInfluenceCus", getfInfluenceCus())
            .append("fStopReason", getfStopReason())
            .append("fStopRange", getfStopRange())
            .append("fStopProgress", getfStopProgress())
            .append("fRecoveryGasTime", getfRecoveryGasTime())
            .append("fRepStatus", getfRepStatus())
            .append("fGasStopArea", getfGasStopArea())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
