package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 特殊用户管控对象 t_special_user
 * 
 * @author zehong
 * @date 2026-02-02
 */
public class TSpecialUser extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long specialId;

    /** 用户id */
    //@Excel(name = "用户id")
    private Long userId;

    @Excel(name = "用户名称")
    private String nickName;
    @Excel(name = "联系方式")
    private String phone;
    @Excel(name = "地址")
    private String address;

    /** 用户类型 */
    @Excel(name = "用户类型" ,dictType = "t_special_user")
    private String userType;

    /** 管控方案 */
    @Excel(name = "管控方案")
    private String controlPlan;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date conStartTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date conEndTime;

    /** 上报用户id */
    private String userOwnId;

    private String enterpriseId;

    public String getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setSpecialId(Long specialId)
    {
        this.specialId = specialId;
    }

    public Long getSpecialId() 
    {
        return specialId;
    }
    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setUserType(String userType) 
    {
        this.userType = userType;
    }

    public String getUserType() 
    {
        return userType;
    }
    public void setControlPlan(String controlPlan) 
    {
        this.controlPlan = controlPlan;
    }

    public String getControlPlan() 
    {
        return controlPlan;
    }
    public void setConStartTime(Date conStartTime)
    {
        this.conStartTime = conStartTime;
    }

    public Date getConStartTime()
    {
        return conStartTime;
    }
    public void setConEndTime(Date conEndTime)
    {
        this.conEndTime = conEndTime;
    }

    public Date getConEndTime()
    {
        return conEndTime;
    }
    public void setUserOwnId(String userOwnId)
    {
        this.userOwnId = userOwnId;
    }

    public String getUserOwnId() 
    {
        return userOwnId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("specialId", getSpecialId())
            .append("userId", getUserId())
            .append("userType", getUserType())
            .append("controlPlan", getControlPlan())
            .append("conStartTime", getConStartTime())
            .append("conEndTime", getConEndTime())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .append("userOwnId", getUserOwnId())
            .toString();
    }
}
