package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 工程项目信息对象 t_project_info
 *
 * @author zehong
 * @date 2022-03-16
 */
public class TProjectInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 工程项目主键ID */
    private Long projectId;

    /** 工程项目年度 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "工程项目年度", width = 30, dateFormat = "yyyy")
    private Date projectYear;
    /**企业编码*/
    @Excel(name = "企业名称")
    private String enterpriseCode;

    /** 权属单位 */
    private String beyondEnterpriseId;

    /** 门站地址 */
    @Excel(name = "门站地址")
    private String gateStationAddress;

    /** 门站金额 */
    @Excel(name = "门站投资额(万元)")
    private BigDecimal gateStationInvestment;

    /** 门站数量 */
    @Excel(name = "门站数量(个)")
    private Long numberGateStations;

    /** 管道长度 */
    @Excel(name = "管道长度(米)")
    private Long pipeLength;

    /** 管道金额 */
    @Excel(name = "管道投资额(万元)")
    private BigDecimal pipeInvestment;

    /** 附件地址 */
    private String nearbyAddress;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public String getBeyondEnterpriseId() {
        return beyondEnterpriseId;
    }

    public void setBeyondEnterpriseId(String beyondEnterpriseId) {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public String getEnterpriseCode() {
        return enterpriseCode;
    }

    public void setEnterpriseCode(String enterpriseCode) {
        this.enterpriseCode = enterpriseCode;
    }

    public void setProjectId(Long projectId)
    {
        this.projectId = projectId;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getProjectId() {
        return projectId;
    }

    public Date getProjectYear() {
        return projectYear;
    }

    public void setProjectYear(Date projectYear) {
        this.projectYear = projectYear;
    }

    public void setGateStationAddress(String gateStationAddress) {
        this.gateStationAddress = gateStationAddress;
    }

    public String getGateStationAddress()
    {
        return gateStationAddress;
    }
    public void setGateStationInvestment(BigDecimal gateStationInvestment)
    {
        this.gateStationInvestment = gateStationInvestment;
    }

    public BigDecimal getGateStationInvestment()
    {
        return gateStationInvestment;
    }
    public void setNumberGateStations(Long numberGateStations)
    {
        this.numberGateStations = numberGateStations;
    }

    public Long getNumberGateStations()
    {
        return numberGateStations;
    }
    public void setPipeLength(Long pipeLength)
    {
        this.pipeLength = pipeLength;
    }

    public Long getPipeLength()
    {
        return pipeLength;
    }
    public void setPipeInvestment(BigDecimal pipeInvestment)
    {
        this.pipeInvestment = pipeInvestment;
    }

    public BigDecimal getPipeInvestment()
    {
        return pipeInvestment;
    }
    public void setNearbyAddress(String nearbyAddress)
    {
        this.nearbyAddress = nearbyAddress;
    }

    public String getNearbyAddress()
    {
        return nearbyAddress;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }

    @Override
    public String toString() {
        return "TProjectInfo{" +
                "projectId=" + projectId +
                ", projectYear=" + projectYear +
                ", beyondEnterpriseId=" + beyondEnterpriseId +
                ", gateStationAddress='" + gateStationAddress + '\'' +
                ", gateStationInvestment=" + gateStationInvestment +
                ", numberGateStations=" + numberGateStations +
                ", pipeLength=" + pipeLength +
                ", pipeInvestment=" + pipeInvestment +
                ", enterpriseCode='" + enterpriseCode + '\'' +
                ", nearbyAddress='" + nearbyAddress + '\'' +
                ", isDel='" + isDel + '\'' +
                ", remarks='" + remarks + '\'' +
                '}';
    }
}
