package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 从业人员信息对象 t_practitioner_info
 *
 * @author zehong
 * @date 2023-08-16
 */
public class TPractitionerInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 从业人员主键 */
    private Long practitionerId;

    /** 储配站 */
    private Long stationId;

    @Excel(name = "储配站")
    private String stationName;

    /** 工号 */
    @Excel(name = "工号")
    private String practitionerNum;

    /** 姓名 */
    @Excel(name = "姓名")
    private String name;

    /** 性别 */
    @Excel(name = "性别: 0.男 1女")
    private String sex;

    /** 出生日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "出生日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date birthDate;

    /** 岗位 */

    private Long postId;

    @Excel(name = "岗位")
    private String postName;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String telNum;

    /** 配送区域 */
    @Excel(name = "配送区域")
    private String deliveryArea;

    /** 人员照片 */
    @Excel(name = "人员照片")
    private String personPhoto;

    /** 证书文件 */
    @Excel(name = "证书文件")
    private String licenseFile;

    /** 从业资格编号 */
    @Excel(name = "从业资格编号")
    private String certificateNum;

    /** 从业资格证有效时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "从业资格证有效时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date certificateEffectiveDate;

    /** 密码 */
    @Excel(name = "密码")
    private String password;

    /** 删除状态：0.否 1.是 */
    private String isDel;

    /**
     * 验证码
     */
    private String code;

    /**
     * 唯一标识
     */
    private String uuid = "";


    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setPractitionerId(Long practitionerId)
    {
        this.practitionerId = practitionerId;
    }

    public Long getPractitionerId()
    {
        return practitionerId;
    }
    public void setStationId(Long stationId)
    {
        this.stationId = stationId;
    }

    public Long getStationId()
    {
        return stationId;
    }
    public void setPractitionerNum(String practitionerNum)
    {
        this.practitionerNum = practitionerNum;
    }

    public String getPractitionerNum()
    {
        return practitionerNum;
    }
    public void setName(String name)
    {
        this.name = name;
    }

    public String getName()
    {
        return name;
    }
    public void setSex(String sex)
    {
        this.sex = sex;
    }

    public String getSex()
    {
        return sex;
    }
    public void setBirthDate(Date birthDate)
    {
        this.birthDate = birthDate;
    }

    public Date getBirthDate()
    {
        return birthDate;
    }
    public void setPostId(Long postId)
    {
        this.postId = postId;
    }

    public Long getPostId()
    {
        return postId;
    }
    public void setTelNum(String telNum)
    {
        this.telNum = telNum;
    }

    public String getTelNum()
    {
        return telNum;
    }
    public void setDeliveryArea(String deliveryArea)
    {
        this.deliveryArea = deliveryArea;
    }

    public String getDeliveryArea()
    {
        return deliveryArea;
    }
    public void setPersonPhoto(String personPhoto)
    {
        this.personPhoto = personPhoto;
    }

    public String getPersonPhoto()
    {
        return personPhoto;
    }
    public void setLicenseFile(String licenseFile)
    {
        this.licenseFile = licenseFile;
    }

    public String getLicenseFile()
    {
        return licenseFile;
    }
    public void setCertificateNum(String certificateNum)
    {
        this.certificateNum = certificateNum;
    }

    public String getCertificateNum()
    {
        return certificateNum;
    }
    public void setCertificateEffectiveDate(Date certificateEffectiveDate)
    {
        this.certificateEffectiveDate = certificateEffectiveDate;
    }

    public Date getCertificateEffectiveDate()
    {
        return certificateEffectiveDate;
    }
    public void setPassword(String password)
    {
        this.password = password;
    }

    public String getPassword()
    {
        return password;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    public String getStationName() {
        return stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    @Override
    public String toString() {
        return "TPractitionerInfo{" +
                "practitionerId=" + practitionerId +
                ", stationId=" + stationId +
                ", stationName='" + stationName + '\'' +
                ", practitionerNum='" + practitionerNum + '\'' +
                ", name='" + name + '\'' +
                ", sex='" + sex + '\'' +
                ", birthDate=" + birthDate +
                ", postId=" + postId +
                ", postName='" + postName + '\'' +
                ", telNum='" + telNum + '\'' +
                ", deliveryArea='" + deliveryArea + '\'' +
                ", personPhoto='" + personPhoto + '\'' +
                ", licenseFile='" + licenseFile + '\'' +
                ", certificateNum='" + certificateNum + '\'' +
                ", certificateEffectiveDate=" + certificateEffectiveDate +
                ", password='" + password + '\'' +
                ", isDel='" + isDel + '\'' +
                ", code='" + code + '\'' +
                ", uuid='" + uuid + '\'' +
                '}';
    }
}
