package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.utils.DateUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.util.Date;

/**
 * 老旧管网-改造计划和进度对象 t_pipe_old_plan_process
 * 
 * @author zehong
 * @date 2024-06-15
 */
public class TPipeOldPlanProcess extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fOldPlanProcessId;

    /** uuid:省平台对接必传参数 */
    private String fUuid;

    /** 燃气企业编码，可为空 */
    private String fEntUuid;

    private String fEnterpriseId;

    /**
     * 燃气企业名称 导出用
     */
    @Excel(name = "燃气企业")
    private String enterpriseName;

    /** 项目所在县级行政区 */
    private Long fRegion;

    /**
     * 项目所在县级行政区 导出用
     */
    @Excel(name = "项目所在县级行政区")
    private String regionName;

    /** 项目名称 */
    @Excel(name = "项目名称")
    private String fProjectName;

    /** 关联对象类型

            PIPE(市政管网管线分段)

            YARD(庭院管网所在小区)

            STATION(厂站和设施)

            RESIDENT（居民用户）

            UNIT(单位用户) */
    @Excel(name = "关联对象类型", dictType = "t_relation_object_type")
    private String fRelationObjectType;

    /** 年度(格式 yyyy) */
    @Excel(name = "年度")
    private String fYear;

    /** 项目开始时间 */
    @Excel(name = "项目开始时间")
    private String fStartTime;

    /** 项目结束时间 */
    @Excel(name = "项目结束时间")
    private String fEndTime;

    /** 项目总投资，单位：万元 */
    private Long fTotalInvestment;

    /** 创建时间 */
    private String fCreateTime;

    /** 修改时间 */
    private String fUpdateTime;

    /** 实施主体 */
    private String fSubjectImplementation;

    /** 联系人 */
    @Excel(name = "联系人")
    private String fConcatPerson;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String fConcatTel;

    /** 建设内容 */
    @Excel(name = "建设内容")
    private String fConstructionContent;

    /** 实际改造完成时间*/
    @Excel(name = "实际改造完成时间")
    private String fActualFinishTime;

    /** 当前改造进度，填写百分比，100为完成 */
    @Excel(name = "当前改造进度")
    private Float fReconstructionProgress;

    /** 当前资金拨付进度，填写百分比，100为完成 */
    @Excel(name = "当前资金拨付进度")
    private Float fFundsDisbursementProgress;

    /** 是否已上传，1-是，0-否 */
    @Excel(name = "上报状态",readConverterExp = "1=已上报,0=未上报")
    private String fUploadType;

    /** 上传时间，yyyy-MM-dd hh:mm:ss */
    @Excel(name = "上报时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:m")
    private String fUploadTime;

    /**
     * 政府端上传数据
     */
    /** 是否已上传，1-是，0-否 */
    @Excel(name = "上报省厅状态",readConverterExp = "1=已上报,0=未上报")
    private String govUploadState;

    /** 政府端上传时间，yyyy-MM-dd hh:mm:ss */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
    @Excel(name = "上报省厅时间")
    private Date govUploadTime;

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getGovUploadState() {
        return govUploadState;
    }

    public void setGovUploadState(String govUploadState) {
        this.govUploadState = govUploadState;
    }

    public Date getGovUploadTime() {
        return govUploadTime;
    }

    public void setGovUploadTime(Date govUploadTime) {
        this.govUploadTime = govUploadTime;
    }

    public String getfEnterpriseId() {
        return fEnterpriseId;
    }

    public void setfEnterpriseId(String fEnterpriseId) {
        this.fEnterpriseId = fEnterpriseId;
    }

    public void setfOldPlanProcessId(Long fOldPlanProcessId)
    {
        this.fOldPlanProcessId = fOldPlanProcessId;
    }

    public Long getfOldPlanProcessId() 
    {
        return fOldPlanProcessId;
    }
    public void setfUuid(String fUuid) 
    {
        this.fUuid = fUuid;
    }

    public String getfUuid() 
    {
        return fUuid;
    }
    public void setfEntUuid(String fEntUuid) 
    {
        this.fEntUuid = fEntUuid;
    }

    public String getfEntUuid() 
    {
        return fEntUuid;
    }
    public void setfRegion(Long fRegion) 
    {
        this.fRegion = fRegion;
    }

    public Long getfRegion() 
    {
        return fRegion;
    }
    public void setfProjectName(String fProjectName) 
    {
        this.fProjectName = fProjectName;
    }

    public String getfProjectName() 
    {
        return fProjectName;
    }
    public void setfRelationObjectType(String fRelationObjectType) 
    {
        this.fRelationObjectType = fRelationObjectType;
    }

    public String getfRelationObjectType() 
    {
        return fRelationObjectType;
    }
    public void setfYear(String fYear) 
    {
        this.fYear = fYear;
    }

    public String getfYear() 
    {
        return fYear;
    }
    public void setfStartTime(String fStartTime) 
    {
        this.fStartTime = fStartTime;
    }

    public String getfStartTime() 
    {
        return fStartTime;
    }
    public void setfEndTime(String fEndTime) 
    {
        this.fEndTime = fEndTime;
    }

    public String getfEndTime() 
    {
        return fEndTime;
    }
    public void setfTotalInvestment(Long fTotalInvestment) 
    {
        this.fTotalInvestment = fTotalInvestment;
    }

    public Long getfTotalInvestment() 
    {
        return fTotalInvestment;
    }
    public void setfCreateTime(String fCreateTime) 
    {
        this.fCreateTime = fCreateTime;
    }

    public String getfCreateTime() 
    {
        return fCreateTime;
    }
    public void setfUpdateTime(String fUpdateTime) 
    {
        this.fUpdateTime = fUpdateTime;
    }

    public String getfUpdateTime() 
    {
        return fUpdateTime;
    }
    public void setfSubjectImplementation(String fSubjectImplementation) 
    {
        this.fSubjectImplementation = fSubjectImplementation;
    }

    public String getfSubjectImplementation() 
    {
        return fSubjectImplementation;
    }
    public void setfConcatPerson(String fConcatPerson) 
    {
        this.fConcatPerson = fConcatPerson;
    }

    public String getfConcatPerson() 
    {
        return fConcatPerson;
    }
    public void setfConcatTel(String fConcatTel) 
    {
        this.fConcatTel = fConcatTel;
    }

    public String getfConcatTel() 
    {
        return fConcatTel;
    }
    public void setfConstructionContent(String fConstructionContent) 
    {
        this.fConstructionContent = fConstructionContent;
    }

    public String getfConstructionContent() 
    {
        return fConstructionContent;
    }
    public void setfActualFinishTime(String fActualFinishTime) 
    {
        this.fActualFinishTime = fActualFinishTime;
    }

    public String getfActualFinishTime() 
    {
        return fActualFinishTime;
    }
    public void setfReconstructionProgress(Float fReconstructionProgress)
    {
        this.fReconstructionProgress = fReconstructionProgress;
    }

    public Float getfReconstructionProgress()
    {
        return fReconstructionProgress;
    }
    public void setfFundsDisbursementProgress(Float fFundsDisbursementProgress)
    {
        this.fFundsDisbursementProgress = fFundsDisbursementProgress;
    }

    public Float getfFundsDisbursementProgress()
    {
        return fFundsDisbursementProgress;
    }
    public void setfUploadType(String fUploadType) 
    {
        this.fUploadType = fUploadType;
    }

    public String getfUploadType() 
    {
        return fUploadType;
    }
    public void setfUploadTime(String fUploadTime) 
    {
        this.fUploadTime = fUploadTime;
    }

    public String getfUploadTime() 
    {
        return fUploadTime;
    }

    public void updateFields() {
        this.fUploadType = govUploadState;
        if (govUploadTime != null) {
            this.fUploadTime = DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM_SS,govUploadTime);
        } else {
            this.fUploadTime = null;
        }
    }
    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fOldPlanProcessId", getfOldPlanProcessId())
            .append("fUuid", getfUuid())
            .append("fEntUuid", getfEntUuid())
            .append("fRegion", getfRegion())
            .append("fProjectName", getfProjectName())
            .append("fRelationObjectType", getfRelationObjectType())
            .append("fYear", getfYear())
            .append("fStartTime", getfStartTime())
            .append("fEndTime", getfEndTime())
            .append("fTotalInvestment", getfTotalInvestment())
            .append("fCreateTime", getfCreateTime())
            .append("fUpdateTime", getfUpdateTime())
            .append("fSubjectImplementation", getfSubjectImplementation())
            .append("fConcatPerson", getfConcatPerson())
            .append("fConcatTel", getfConcatTel())
            .append("fConstructionContent", getfConstructionContent())
            .append("fActualFinishTime", getfActualFinishTime())
            .append("fReconstructionProgress", getfReconstructionProgress())
            .append("fFundsDisbursementProgress", getfFundsDisbursementProgress())
            .append("fUploadType", getfUploadType())
            .append("fUploadTime", getfUploadTime())
            .toString();
    }
}
