package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 巡检任务对象 t_patrol_work_info
 * 
 * @author zehong
 * @date 2023-08-05
 */
public class TPatrolWorkInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 巡检任务id */
    private Long workId;

    /** 任务名称 */
    @Excel(name = "任务名称")
    private String workName;

    /** 任务描述 */
    @Excel(name = "任务描述")
    private String workDescribe;

    /** 巡检点多个 */
    @Excel(name = "巡检点多个")
    private String pantrolId;

    /** 巡检人员id */
    @Excel(name = "巡检人员id")
    private Long tEmployedPeopleInfo;

    /** 检测点数量 */
    @Excel(name = "检测点数量")
    private Integer inspectPointNum;

    /** 检测完成数量 */
    @Excel(name = "检测完成数量")
    private Integer inspectSuccessNum;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    public void setWorkId(Long workId) 
    {
        this.workId = workId;
    }

    public Long getWorkId() 
    {
        return workId;
    }
    public void setWorkName(String workName) 
    {
        this.workName = workName;
    }

    public String getWorkName() 
    {
        return workName;
    }
    public void setWorkDescribe(String workDescribe) 
    {
        this.workDescribe = workDescribe;
    }

    public String getWorkDescribe() 
    {
        return workDescribe;
    }
    public void setPantrolId(String pantrolId) 
    {
        this.pantrolId = pantrolId;
    }

    public String getPantrolId() 
    {
        return pantrolId;
    }
    public void settEmployedPeopleInfo(Long tEmployedPeopleInfo) 
    {
        this.tEmployedPeopleInfo = tEmployedPeopleInfo;
    }

    public Long gettEmployedPeopleInfo() 
    {
        return tEmployedPeopleInfo;
    }
    public void setInspectPointNum(Integer inspectPointNum) 
    {
        this.inspectPointNum = inspectPointNum;
    }

    public Integer getInspectPointNum() 
    {
        return inspectPointNum;
    }
    public void setInspectSuccessNum(Integer inspectSuccessNum) 
    {
        this.inspectSuccessNum = inspectSuccessNum;
    }

    public Integer getInspectSuccessNum() 
    {
        return inspectSuccessNum;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("workId", getWorkId())
            .append("workName", getWorkName())
            .append("workDescribe", getWorkDescribe())
            .append("pantrolId", getPantrolId())
            .append("tEmployedPeopleInfo", gettEmployedPeopleInfo())
            .append("inspectPointNum", getInspectPointNum())
            .append("inspectSuccessNum", getInspectSuccessNum())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
