package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 液化石油配送记录对象 t_lpg_delivery_record
 * 
 * @author zehong
 * @date 2024-07-22
 */
public class TLpgDeliveryRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 配送记录主键 */
    private Long deliveryRecordId;

    /** 储配站 */
    @Excel(name = "储配站")
    private String stationName;

    @Excel(name = "气瓶条码")
    private String bottleCode;

    /** 配送人员 */
    @Excel(name = "配送人员")
    private String deliveryPerson;

    /** 车辆代码 */
    @Excel(name = "车辆代码")
    private String vehicleCode;

    /** 用户 */
    @Excel(name = "用户")
    private String gasUser;

    /** 0.居民 1.非居民 */
    @Excel(name = "用户类型(0=居民,1=非居民)")
    private String gasUserType;

    /** 配送地址 */
    @Excel(name = "配送地址")
    private String deliveryAddress;

    /** 配送时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "配送时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date deliveryDate;

    /** 删除状态：0.否 1.是 */
    private String isDel;

    private Long userId;

    /**
     * 用户自有编号 第三方对接时接收下数据先
     */
    private String userOwnId;

    public void setDeliveryRecordId(Long deliveryRecordId) 
    {
        this.deliveryRecordId = deliveryRecordId;
    }

    public Long getDeliveryRecordId() 
    {
        return deliveryRecordId;
    }
    public void setStationName(String stationName)
    {
        this.stationName = stationName;
    }

    public String getStationName()
    {
        return stationName;
    }

    public String getBottleCode() {
        return bottleCode;
    }

    public void setBottleCode(String bottleCode) {
        this.bottleCode = bottleCode;
    }

    public void setDeliveryPerson(String deliveryPerson)
    {
        this.deliveryPerson = deliveryPerson;
    }

    public String getDeliveryPerson() 
    {
        return deliveryPerson;
    }
    public void setVehicleCode(String vehicleCode) 
    {
        this.vehicleCode = vehicleCode;
    }

    public String getVehicleCode() 
    {
        return vehicleCode;
    }
    public void setGasUser(String gasUser) 
    {
        this.gasUser = gasUser;
    }

    public String getGasUser() 
    {
        return gasUser;
    }
    public void setGasUserType(String gasUserType) 
    {
        this.gasUserType = gasUserType;
    }

    public String getGasUserType() 
    {
        return gasUserType;
    }
    public void setDeliveryAddress(String deliveryAddress) 
    {
        this.deliveryAddress = deliveryAddress;
    }

    public String getDeliveryAddress() 
    {
        return deliveryAddress;
    }
    public void setDeliveryDate(Date deliveryDate) 
    {
        this.deliveryDate = deliveryDate;
    }

    public Date getDeliveryDate() 
    {
        return deliveryDate;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserOwnId() {
        return userOwnId;
    }

    public void setUserOwnId(String userOwnId) {
        this.userOwnId = userOwnId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("deliveryRecordId", getDeliveryRecordId())
            .append("stationName", getStationName())
            .append("deliveryPerson", getDeliveryPerson())
            .append("vehicleCode", getVehicleCode())
            .append("gasUser", getGasUser())
            .append("gasUserType", getGasUserType())
            .append("deliveryAddress", getDeliveryAddress())
            .append("deliveryDate", getDeliveryDate())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
