package com.zehong.system.domain;
import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 巡检事故对象 t_inspection_accident
 *
 * @author zehong
 * @date 2026-02-02
 */
public class TInspectionAccident extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 事故名称 */
    @Excel(name = "事故名称")
    private String accidentName;

    /** 事故发生时间 */
    @Excel(name = "事故发生时间")
    private String happenDate;

    /** 事故地点 */
    @Excel(name = "事故地点")
    private String accidentLocation;

    /** 经度 */
    private BigDecimal longitude;

    /** 纬度 */
    private BigDecimal latitude;

    /** 事故描述 */
    @Excel(name = "事故描述")
    private String accidentDescription;

    /** 事故原因 */
    @Excel(name = "事故原因")
    private String accidentReason;

    /** 责任人 */
    @Excel(name = "责任人")
    private String obligationPerson;

    /** 权属单位 */
    @Excel(name = "权属单位")
    private String beyondEnterpriseId;

    /** 权属单位名称 */
    @Excel(name = "权属单位名称")
    private String beyondEnterpriseName;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setAccidentName(String accidentName)
    {
        this.accidentName = accidentName;
    }

    public String getAccidentName()
    {
        return accidentName;
    }
    public void setHappenDate(String happenDate)
    {
        this.happenDate = happenDate;
    }

    public String getHappenDate()
    {
        return happenDate;
    }
    public void setAccidentLocation(String accidentLocation)
    {
        this.accidentLocation = accidentLocation;
    }

    public String getAccidentLocation()
    {
        return accidentLocation;
    }
    public void setLongitude(BigDecimal longitude)
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude()
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude)
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude()
    {
        return latitude;
    }
    public void setAccidentDescription(String accidentDescription)
    {
        this.accidentDescription = accidentDescription;
    }

    public String getAccidentDescription()
    {
        return accidentDescription;
    }
    public void setAccidentReason(String accidentReason)
    {
        this.accidentReason = accidentReason;
    }

    public String getAccidentReason()
    {
        return accidentReason;
    }
    public void setObligationPerson(String obligationPerson)
    {
        this.obligationPerson = obligationPerson;
    }

    public String getObligationPerson()
    {
        return obligationPerson;
    }
    public void setBeyondEnterpriseId(String beyondEnterpriseId)
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public String getBeyondEnterpriseId()
    {
        return beyondEnterpriseId;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName)
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName()
    {
        return beyondEnterpriseName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("accidentName", getAccidentName())
                .append("happenDate", getHappenDate())
                .append("accidentLocation", getAccidentLocation())
                .append("longitude", getLongitude())
                .append("latitude", getLatitude())
                .append("accidentDescription", getAccidentDescription())
                .append("accidentReason", getAccidentReason())
                .append("obligationPerson", getObligationPerson())
                .append("beyondEnterpriseId", getBeyondEnterpriseId())
                .append("beyondEnterpriseName", getBeyondEnterpriseName())
                .append("createTime", getCreateTime())
                .append("remark", getRemark())
                .toString();
    }
}
