package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 入户安检结果对象 t_inspect_report
 * 
 * @author zehong
 * @date 2026-02-02
 */
public class TInspectReport extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 系统id */
    private Long reportId;

    /** 年度 */
    @Excel(name = "年度")
    private Integer annual;

    /** 安检记录编码 */
    @Excel(name = "安检记录编码")
    private String securityCodeIn;

    /** 外部安检记录编码 */
    @Excel(name = "外部安检记录编码")
    private String securityCode;

    /** 用户编码 */
    @Excel(name = "用户编码")
    private Long userNo;

    /** 用户姓名 */
    @Excel(name = "用户姓名")
    private String userName;

    /** 入户时间 */
    @Excel(name = "入户时间")
    private String indoorTime;

    /** 入户状态，DONE-已入户，REJ-入户拒绝，NONE-到访不遇 */
    @Excel(name = "入户状态，DONE-已入户，REJ-入户拒绝，NONE-到访不遇")
    private String indoorStatus;

    /** 市区名称 */
    @Excel(name = "市区名称")
    private String region;

    /** 居住区id */
    @Excel(name = "居住区id")
    private Long village;

    /** 小区+门牌号 */
    @Excel(name = "小区+门牌号")
    private String houseNumber;

    /** 手机号 */
    @Excel(name = "手机号")
    private String phoneNumber;

    /** 所属组织编码/统一社会信用代码 */
    @Excel(name = "所属组织编码/统一社会信用代码")
    private String deptCode;

    /** 企业id */
    @Excel(name = "企业id")
    private String companyInfoId;

    /** 第三方用户id */
    @Excel(name = "第三方用户id")
    private String userOwnId;



    //企业名称
    private String enterpriseName;
    //居民区名称
    private String villageName;
    //安检数量
    private String doneNum;
    //拒绝安检数量
    private String rejNum;
    //到访不遇数量
    private String noneNum;
    //最后上报时间
    private String lastTime;

    public Long getUserNo() {
        return userNo;
    }

    public void setUserNo(Long userNo) {
        this.userNo = userNo;
    }

    public String getCompanyInfoId() {
        return companyInfoId;
    }

    public void setCompanyInfoId(String companyInfoId) {
        this.companyInfoId = companyInfoId;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    public String getVillageName() {
        return villageName;
    }

    public void setVillageName(String villageName) {
        this.villageName = villageName;
    }

    public String getDoneNum() {
        return doneNum;
    }

    public void setDoneNum(String doneNum) {
        this.doneNum = doneNum;
    }

    public String getRejNum() {
        return rejNum;
    }

    public void setRejNum(String rejNum) {
        this.rejNum = rejNum;
    }

    public String getNoneNum() {
        return noneNum;
    }

    public void setNoneNum(String noneNum) {
        this.noneNum = noneNum;
    }

    public String getLastTime() {
        return lastTime;
    }

    public void setLastTime(String lastTime) {
        this.lastTime = lastTime;
    }

    public void setReportId(Long reportId)
    {
        this.reportId = reportId;
    }

    public Long getReportId() 
    {
        return reportId;
    }
    public void setAnnual(Integer annual) 
    {
        this.annual = annual;
    }

    public Integer getAnnual() 
    {
        return annual;
    }
    public void setSecurityCodeIn(String securityCodeIn)
    {
        this.securityCodeIn = securityCodeIn;
    }

    public String getSecurityCodeIn()
    {
        return securityCodeIn;
    }
    public void setSecurityCode(String securityCode) 
    {
        this.securityCode = securityCode;
    }

    public String getSecurityCode()
    {
        return securityCode;
    }

    public void setUserName(String userName) 
    {
        this.userName = userName;
    }

    public String getUserName() 
    {
        return userName;
    }
    public void setIndoorTime(String indoorTime) 
    {
        this.indoorTime = indoorTime;
    }

    public String getIndoorTime() 
    {
        return indoorTime;
    }
    public void setIndoorStatus(String indoorStatus) 
    {
        this.indoorStatus = indoorStatus;
    }

    public String getIndoorStatus() 
    {
        return indoorStatus;
    }
    public void setRegion(String region) 
    {
        this.region = region;
    }

    public String getRegion() 
    {
        return region;
    }
    public void setVillage(Long village) 
    {
        this.village = village;
    }

    public Long getVillage() 
    {
        return village;
    }
    public void setHouseNumber(String houseNumber) 
    {
        this.houseNumber = houseNumber;
    }

    public String getHouseNumber() 
    {
        return houseNumber;
    }
    public void setPhoneNumber(String phoneNumber) 
    {
        this.phoneNumber = phoneNumber;
    }

    public String getPhoneNumber() 
    {
        return phoneNumber;
    }
    public void setDeptCode(String deptCode) 
    {
        this.deptCode = deptCode;
    }

    public String getDeptCode() 
    {
        return deptCode;
    }

    public void setUserOwnId(String userOwnId) 
    {
        this.userOwnId = userOwnId;
    }

    public String getUserOwnId() 
    {
        return userOwnId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("reportId", getReportId())
            .append("annual", getAnnual())
            .append("securityCodeIn", getSecurityCodeIn())
            .append("securityCode", getSecurityCode())
            .append("userNo", getUserNo())
            .append("userName", getUserName())
            .append("indoorTime", getIndoorTime())
            .append("indoorStatus", getIndoorStatus())
            .append("region", getRegion())
            .append("village", getVillage())
            .append("houseNumber", getHouseNumber())
            .append("phoneNumber", getPhoneNumber())
            .append("deptCode", getDeptCode())
            .append("companyInfoId", getCompanyInfoId())
            .append("createTime", getCreateTime())
            .append("userOwnId", getUserOwnId())
            .toString();
    }
}
