package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 监督检查-监督检查发现隐患及整改，执法结果对象 t_ins_haz_ref
 * 
 * @author zehong
 * @date 2024-05-21
 */
public class TInsHazRef extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fInsHazRefId;

    /** 隐患唯一编码 */
    @Excel(name = "隐患唯一编码")
    private String fHazardUniqueCode;

    /** 隐患在市级平台系统中的自有编号 */
    @Excel(name = "隐患在市级平台系统中的自有编号")
    private String fHazardOutUniqueCode;

    /** 检查记录编码，关联生成该隐患的检查记录 */
    @Excel(name = "检查记录编码，关联生成该隐患的检查记录")
    private String fCheckCode;

    /** 涉及供气企业编码 */
    @Excel(name = "涉及供气企业编码")
    private String fInvolveEnterpriseCode;

    /** 检查对象分类，按分类代码表23 分类填写

            23-0100 ：气代煤

            23-0200-0201：传统电代煤

            23-0200-0202：石墨烯

            23-0200-0203：聚能

            23-0200-0204：空气源热泵

            23-0200-0205：地源热泵

            23-9900-0301：集中供热

            23-9900-0302：光伏+

            23-9900-0303：光热+

            23-9900-0304：醇基燃料

            23-9900-0305：生物质 */
    @Excel(name = "检查对象分类",dictType = "t_type_code")
    private String fObjType;

    /** 对象编码 */
    @Excel(name = "对象编码")
    private String fObjCode;

    /** 对象所在行政区，县级行政区ID */
    @Excel(name = "对象所在行政区，县级行政区ID")
    private String fObjBelongRegionId;

    /** 监督检查时间 yyyy-MM-dd hh:mm:ss */
    @Excel(name = "监督检查时间 yyyy-MM-dd hh:mm:ss")
    private String fCheckTime;

    /** 隐患分类分级编码 */
    @Excel(name = "隐患分类分级编码")
    private String fHazardTypeLevelId;

    /** 隐患分类分级标准中的内容不足以表述隐

            患，或隐患分类分级编码对应了“其他”类隐

            患的，应该用补充说明把隐患描述完整 */
    @Excel(name = "隐患描述")
    private String fHazardDesc;

    /** 0-未整改，1-已整改，2-已管控，3-部分整改 */
    @Excel(name = "整改状态",dictType = "t_rectification_status")
    private String fRectificationStatus;

    /** 整改资金 单位： 万元 */
    @Excel(name = "整改资金 单位： 万元")
    private String fRectificationFund;

    /** 整改完成日期 yyyy-MM-dd */
    @Excel(name = "整改完成日期")
    private String fCompletionDate;

    /** 整改或管控措施描述 */
    @Excel(name = "整改或管控措施描述")
    private String fControlMeasure;

    /** 隐患整改前照片 */
    @Excel(name = "隐患整改前照片")
    private String fBeforePicture;

    /** 隐患整改后照片 */
    @Excel(name = "隐患整改后照片")
    private String fAfterPicture;

    /** 1 是，0 否 */
    @Excel(name = "是否执行",readConverterExp = "1=是,0=否")
    private String fIsEnforcement;

    /** 1 警告，2 罚款，3 没收违法所得、没收非

            法财物，4 责令停产停业，5 暂扣或者吊销

            许可证、暂扣或者吊销执照，6 行政拘留，

            7 法律、行政法规规定的其他行政处罚 */
    @Excel(name = "处罚措施",dictType = "t_enforcement_type")
    private String fEnforcementType;

    /** 处罚金额，单位：万元 */
    @Excel(name = "处罚金额，单位：万元")
    private Long fPenaltyAmount;

    /** 其他执法情况说明 */
    @Excel(name = "其他执法情况说明")
    private String fPenaltyDesc;

    /** 执法日期 yyyy-MM-dd */
    @Excel(name = "执法日期")
    private String fPenaltyDate;

    /** 备注 */
    @Excel(name = "备注")
    private String fRemark;

    /** 最后修改时间 yyyy-MM-dd hh:mm:ss */
    @Excel(name = "最后修改时间")
    private String fLastTime;

    public void setfInsHazRefId(Long fInsHazRefId) 
    {
        this.fInsHazRefId = fInsHazRefId;
    }

    public Long getfInsHazRefId() 
    {
        return fInsHazRefId;
    }
    public void setfHazardUniqueCode(String fHazardUniqueCode) 
    {
        this.fHazardUniqueCode = fHazardUniqueCode;
    }

    public String getfHazardUniqueCode() 
    {
        return fHazardUniqueCode;
    }
    public void setfHazardOutUniqueCode(String fHazardOutUniqueCode) 
    {
        this.fHazardOutUniqueCode = fHazardOutUniqueCode;
    }

    public String getfHazardOutUniqueCode() 
    {
        return fHazardOutUniqueCode;
    }
    public void setfCheckCode(String fCheckCode) 
    {
        this.fCheckCode = fCheckCode;
    }

    public String getfCheckCode() 
    {
        return fCheckCode;
    }
    public void setfInvolveEnterpriseCode(String fInvolveEnterpriseCode) 
    {
        this.fInvolveEnterpriseCode = fInvolveEnterpriseCode;
    }

    public String getfInvolveEnterpriseCode() 
    {
        return fInvolveEnterpriseCode;
    }
    public void setfObjType(String fObjType) 
    {
        this.fObjType = fObjType;
    }

    public String getfObjType() 
    {
        return fObjType;
    }
    public void setfObjCode(String fObjCode) 
    {
        this.fObjCode = fObjCode;
    }

    public String getfObjCode() 
    {
        return fObjCode;
    }
    public void setfObjBelongRegionId(String fObjBelongRegionId) 
    {
        this.fObjBelongRegionId = fObjBelongRegionId;
    }

    public String getfObjBelongRegionId() 
    {
        return fObjBelongRegionId;
    }
    public void setfCheckTime(String fCheckTime) 
    {
        this.fCheckTime = fCheckTime;
    }

    public String getfCheckTime() 
    {
        return fCheckTime;
    }
    public void setfHazardTypeLevelId(String fHazardTypeLevelId) 
    {
        this.fHazardTypeLevelId = fHazardTypeLevelId;
    }

    public String getfHazardTypeLevelId() 
    {
        return fHazardTypeLevelId;
    }
    public void setfHazardDesc(String fHazardDesc) 
    {
        this.fHazardDesc = fHazardDesc;
    }

    public String getfHazardDesc() 
    {
        return fHazardDesc;
    }
    public void setfRectificationStatus(String fRectificationStatus) 
    {
        this.fRectificationStatus = fRectificationStatus;
    }

    public String getfRectificationStatus() 
    {
        return fRectificationStatus;
    }
    public void setfRectificationFund(String fRectificationFund) 
    {
        this.fRectificationFund = fRectificationFund;
    }

    public String getfRectificationFund() 
    {
        return fRectificationFund;
    }
    public void setfCompletionDate(String fCompletionDate) 
    {
        this.fCompletionDate = fCompletionDate;
    }

    public String getfCompletionDate() 
    {
        return fCompletionDate;
    }
    public void setfControlMeasure(String fControlMeasure) 
    {
        this.fControlMeasure = fControlMeasure;
    }

    public String getfControlMeasure() 
    {
        return fControlMeasure;
    }
    public void setfBeforePicture(String fBeforePicture) 
    {
        this.fBeforePicture = fBeforePicture;
    }

    public String getfBeforePicture() 
    {
        return fBeforePicture;
    }
    public void setfAfterPicture(String fAfterPicture) 
    {
        this.fAfterPicture = fAfterPicture;
    }

    public String getfAfterPicture() 
    {
        return fAfterPicture;
    }
    public void setfIsEnforcement(String fIsEnforcement) 
    {
        this.fIsEnforcement = fIsEnforcement;
    }

    public String getfIsEnforcement() 
    {
        return fIsEnforcement;
    }
    public void setfEnforcementType(String fEnforcementType) 
    {
        this.fEnforcementType = fEnforcementType;
    }

    public String getfEnforcementType() 
    {
        return fEnforcementType;
    }
    public void setfPenaltyAmount(Long fPenaltyAmount) 
    {
        this.fPenaltyAmount = fPenaltyAmount;
    }

    public Long getfPenaltyAmount() 
    {
        return fPenaltyAmount;
    }
    public void setfPenaltyDesc(String fPenaltyDesc) 
    {
        this.fPenaltyDesc = fPenaltyDesc;
    }

    public String getfPenaltyDesc() 
    {
        return fPenaltyDesc;
    }
    public void setfPenaltyDate(String fPenaltyDate) 
    {
        this.fPenaltyDate = fPenaltyDate;
    }

    public String getfPenaltyDate() 
    {
        return fPenaltyDate;
    }
    public void setfRemark(String fRemark) 
    {
        this.fRemark = fRemark;
    }

    public String getfRemark() 
    {
        return fRemark;
    }
    public void setfLastTime(String fLastTime) 
    {
        this.fLastTime = fLastTime;
    }

    public String getfLastTime() 
    {
        return fLastTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("fInsHazRefId", getfInsHazRefId())
            .append("fHazardUniqueCode", getfHazardUniqueCode())
            .append("fHazardOutUniqueCode", getfHazardOutUniqueCode())
            .append("fCheckCode", getfCheckCode())
            .append("fInvolveEnterpriseCode", getfInvolveEnterpriseCode())
            .append("fObjType", getfObjType())
            .append("fObjCode", getfObjCode())
            .append("fObjBelongRegionId", getfObjBelongRegionId())
            .append("fCheckTime", getfCheckTime())
            .append("fHazardTypeLevelId", getfHazardTypeLevelId())
            .append("fHazardDesc", getfHazardDesc())
            .append("fRectificationStatus", getfRectificationStatus())
            .append("fRectificationFund", getfRectificationFund())
            .append("fCompletionDate", getfCompletionDate())
            .append("fControlMeasure", getfControlMeasure())
            .append("fBeforePicture", getfBeforePicture())
            .append("fAfterPicture", getfAfterPicture())
            .append("fIsEnforcement", getfIsEnforcement())
            .append("fEnforcementType", getfEnforcementType())
            .append("fPenaltyAmount", getfPenaltyAmount())
            .append("fPenaltyDesc", getfPenaltyDesc())
            .append("fPenaltyDate", getfPenaltyDate())
            .append("fRemark", getfRemark())
            .append("fLastTime", getfLastTime())
            .toString();
    }
}
