package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 隐患整治台账对象 t_hidden_danger_standing_book
 *
 * @author zehong
 * @date 2022-02-09
 */
public class THiddenDangerStandingBook extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 隐患id */
    private Long hiddenId;

    /** 隐患名称 */
    @Excel(name = "隐患名称")
    private String hiddenTitle;

    /** 隐患内容 */
    @Excel(name = "隐患内容")
    private String hiddenContent;

    /** 隐患位置 */
    @Excel(name = "隐患位置")
    private String hiddenLocation;

    /** 经度 */
    private BigDecimal longitude;

    /** 纬度 */
    private BigDecimal latitude;

    /** 隐患等级 */
    @Excel(name = "隐患等级",dictType = "t_hidden_type")
    private String hiddenType;

    /** 隐患发现人员 */
    @Excel(name = "隐患发现人员")
    private String hiddenFindPeople;

    /** 发现时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "发现时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date hiddenFindDate;

    /** 处理方案 */
    @Excel(name = "处理方案")
    private String dealPlan;

    /** 方案路径 */
    private String dealPlanUrl;

    /** 整治情况 */
    @Excel(name = "整治情况",readConverterExp = "1=已完成,2=未完成")
    private String remediation;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除",readConverterExp = "0=否,1=是")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;


    /** 权属单位 */
    private String beyondEnterpriseId;


    /** 权属单位 */
    @Excel(name = "权属单位")
    private String enterpriseName;

    private String source;

    private Long township;

    private int hiddenTroubleLevel;

    private String hiddenTroubleType;

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Long getTownship() {
        return township;
    }

    public void setTownship(Long township) {
        this.township = township;
    }

    public int getHiddenTroubleLevel() {
        return hiddenTroubleLevel;
    }

    public void setHiddenTroubleLevel(int hiddenTroubleLevel) {
        this.hiddenTroubleLevel = hiddenTroubleLevel;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getBeyondEnterpriseId() {
        return beyondEnterpriseId;
    }

    public void setBeyondEnterpriseId(String beyondEnterpriseId) {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public void setHiddenId(Long hiddenId)
    {
        this.hiddenId = hiddenId;
    }

    public Long getHiddenId()
    {
        return hiddenId;
    }
    public void setHiddenTitle(String hiddenTitle)
    {
        this.hiddenTitle = hiddenTitle;
    }

    public String getHiddenTitle()
    {
        return hiddenTitle;
    }
    public void setHiddenContent(String hiddenContent)
    {
        this.hiddenContent = hiddenContent;
    }

    public String getHiddenContent()
    {
        return hiddenContent;
    }
    public void setHiddenLocation(String hiddenLocation)
    {
        this.hiddenLocation = hiddenLocation;
    }

    public String getHiddenLocation()
    {
        return hiddenLocation;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public void setHiddenType(String hiddenType)
    {
        this.hiddenType = hiddenType;
    }

    public String getHiddenType()
    {
        return hiddenType;
    }
    public void setHiddenFindPeople(String hiddenFindPeople)
    {
        this.hiddenFindPeople = hiddenFindPeople;
    }

    public String getHiddenFindPeople()
    {
        return hiddenFindPeople;
    }
    public void setHiddenFindDate(Date hiddenFindDate)
    {
        this.hiddenFindDate = hiddenFindDate;
    }

    public Date getHiddenFindDate()
    {
        return hiddenFindDate;
    }
    public void setDealPlan(String dealPlan)
    {
        this.dealPlan = dealPlan;
    }

    public String getDealPlan()
    {
        return dealPlan;
    }

    public String getDealPlanUrl() {
        return dealPlanUrl;
    }

    public void setDealPlanUrl(String dealPlanUrl) {
        this.dealPlanUrl = dealPlanUrl;
    }

    public void setRemediation(String remediation)
    {
        this.remediation = remediation;
    }

    public String getRemediation()
    {
        return remediation;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }
    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks()
    {
        return remarks;
    }

    public String getHiddenTroubleType() {
        return hiddenTroubleType;
    }

    public void setHiddenTroubleType(String hiddenTroubleType) {
        this.hiddenTroubleType = hiddenTroubleType;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("hiddenId", getHiddenId())
            .append("hiddenTitle", getHiddenTitle())
            .append("hiddenContent", getHiddenContent())
            .append("hiddenLocation", getHiddenLocation())
            .append("hiddenType", getHiddenType())
            .append("hiddenFindPeople", getHiddenFindPeople())
            .append("hiddenFindDate", getHiddenFindDate())
            .append("dealPlan", getDealPlan())
            .append("remediation", getRemediation())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
