package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 探测器对象 t_detector_info
 * 
 * @author zehong
 * @date 2021-11-02
 */
public class TDetectorInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 设备id */
    private Long detectorId;

    /** 企业id */
    private String enterpriseId;

    /** 用户id */
    @Excel(name = "用户id")
    private Long userId;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String detectorName;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String detectorCode;

    /** 设备地址 */
    @Excel(name = "设备地址")
    private String detectorAddr;

    /** 设备类型（1家用报警器，2工业报警器） */
    @Excel(name = "设备类型", readConverterExp = "1家用报警器，2工业报警器")
    private String detectorType;

    /** 检测介质（1甲烷，2氨气，3一氧化碳，4可燃气体，5有毒气体） */
    @Excel(name = "检测介质", readConverterExp = "1甲烷，2氨气，3一氧化碳，4可燃气体，5有毒气体")
    private String medium;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 物联网编号 */
    @Excel(name = "物联网编号")
    private String iotNo;

    /** 联系人 */
    @Excel(name = "联系人")
    private String linkman;

    /** 电话 */
    @Excel(name = "电话")
    private String phone;

    /** 创建时间 */
    private Date creatTime;

    /** 报警时间 */
    private String alarmTime;

    /** 设备状态(0正常，1离线，2报警) */
    @Excel(name = "设备状态")
    private String detectorStatus;

    /** 是否删除(0正常，1删除) */
    @Excel(name = "是否删除(0正常，1删除)")
    private String isDel;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    /**所属设备名称*/
    private String beyondDevicename;

    public String getBeyondDevicename() {
        return beyondDevicename;
    }

    public void setBeyondDevicename(String beyondDevicename) {
        this.beyondDevicename = beyondDevicename;
    }

    public String getEnterpriseName() {
        return enterpriseName;
    }

    public void setEnterpriseName(String enterpriseName) {
        this.enterpriseName = enterpriseName;
    }

    /**所属企业名称*/
    private String enterpriseName;

    public void setDetectorId(Long detectorId) 
    {
        this.detectorId = detectorId;
    }

    public Long getDetectorId() 
    {
        return detectorId;
    }

    public String getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public void setUserId(Long userId)
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setDetectorName(String detectorName) 
    {
        this.detectorName = detectorName;
    }

    public String getDetectorName() 
    {
        return detectorName;
    }
    public void setDetectorCode(String detectorCode) 
    {
        this.detectorCode = detectorCode;
    }

    public String getDetectorCode() 
    {
        return detectorCode;
    }
    public void setDetectorAddr(String detectorAddr) 
    {
        this.detectorAddr = detectorAddr;
    }

    public String getDetectorAddr() 
    {
        return detectorAddr;
    }

    public void setDetectorType(String detectorType) 
    {
        this.detectorType = detectorType;
    }

    public String getDetectorType() 
    {
        return detectorType;
    }
    public void setMedium(String medium) 
    {
        this.medium = medium;
    }

    public String getMedium() 
    {
        return medium;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setIotNo(String iotNo) 
    {
        this.iotNo = iotNo;
    }

    public String getIotNo() 
    {
        return iotNo;
    }
    public void setLinkman(String linkman) 
    {
        this.linkman = linkman;
    }

    public String getLinkman() 
    {
        return linkman;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }

    public Date getCreatTime() {
        return creatTime;
    }

    public void setCreatTime(Date creatTime) {
        this.creatTime = creatTime;
    }

    public String getAlarmTime() {
        return alarmTime;
    }

    public void setAlarmTime(String alarmTime) {
        this.alarmTime = alarmTime;
    }

    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    public String getDetectorStatus() {
        return detectorStatus;
    }

    public void setDetectorStatus(String detectorStatus) {
        this.detectorStatus = detectorStatus;
    }

    public void setRemarks(String remarks)
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }
}
