package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 燃气投诉处置-超时督办对象 t_complain_deal_over_super
 * 
 * @author zehong
 * @date 2024-06-14
 */
public class TComplainDealOverSuper extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long complainDealOverSuperId;

    /** 投诉处置id */
    @Excel(name = "投诉处置id")
    private Long complainDealId;

    /** 督办事由 */
    @Excel(name = "督办事由")
    private String supervisionReasons;

    /** 反馈 */
    @Excel(name = "反馈")
    private String concent;

    /** 超时督办：0-创建，1-企业反馈，2-确认反馈，不确认时监管部门直接改成 0 */
    @Excel(name = "超时督办：0-创建，1-企业反馈，2-确认反馈，不确认时监管部门直接改成 0")
    private String overtimeSupervision;

    public void setComplainDealOverSuperId(Long complainDealOverSuperId) 
    {
        this.complainDealOverSuperId = complainDealOverSuperId;
    }

    public Long getComplainDealOverSuperId() 
    {
        return complainDealOverSuperId;
    }
    public void setComplainDealId(Long complainDealId) 
    {
        this.complainDealId = complainDealId;
    }

    public Long getComplainDealId() 
    {
        return complainDealId;
    }
    public void setSupervisionReasons(String supervisionReasons) 
    {
        this.supervisionReasons = supervisionReasons;
    }

    public String getSupervisionReasons() 
    {
        return supervisionReasons;
    }
    public void setConcent(String concent) 
    {
        this.concent = concent;
    }

    public String getConcent() 
    {
        return concent;
    }
    public void setOvertimeSupervision(String overtimeSupervision) 
    {
        this.overtimeSupervision = overtimeSupervision;
    }

    public String getOvertimeSupervision() 
    {
        return overtimeSupervision;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("complainDealOverSuperId", getComplainDealOverSuperId())
            .append("complainDealId", getComplainDealId())
            .append("supervisionReasons", getSupervisionReasons())
            .append("concent", getConcent())
            .append("overtimeSupervision", getOvertimeSupervision())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .toString();
    }
}
