package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 燃气投诉处置的管理制度维护对象 t_complain_deal_man_sys_set
 *
 * @author zehong
 * @date 2024-06-05
 */
public class TComplainDealManSysSet extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long fComplainDealManSysSetId;

    /** 制度类型 1-投诉举报，2-服务申请，3-咨询建议 */
    @Excel(name = "制度类型 1-投诉举报，2-服务申请，3-咨询建议")
    private String fType;

    /** 办结及时时长-天 */
    @Excel(name = "办结及时时长-天")
    private Long fDay;

    /** 办结及时时长-小时 */
    @Excel(name = "办结及时时长-小时")
    private Long fHours;

    /** 办结及时时长-分钟 */
    @Excel(name = "办结及时时长-分钟")
    private Long fMinutes;

    /** 办结及时时长-秒 */
    @Excel(name = "办结及时时长-秒")
    private Long fSeconds;

    /** 备注 */
    @Excel(name = "备注")
    private String fRemarks;

    public void setfComplainDealManSysSetId(Long fComplainDealManSysSetId)
    {
        this.fComplainDealManSysSetId = fComplainDealManSysSetId;
    }

    public Long getfComplainDealManSysSetId()
    {
        return fComplainDealManSysSetId;
    }
    public void setfType(String fType)
    {
        this.fType = fType;
    }

    public String getfType()
    {
        return fType;
    }
    public void setfDay(Long fDay)
    {
        this.fDay = fDay;
    }

    public Long getfDay()
    {
        return fDay;
    }
    public void setfHours(Long fHours)
    {
        this.fHours = fHours;
    }

    public Long getfHours()
    {
        return fHours;
    }
    public void setfMinutes(Long fMinutes)
    {
        this.fMinutes = fMinutes;
    }

    public Long getfMinutes()
    {
        return fMinutes;
    }
    public void setfSeconds(Long fSeconds)
    {
        this.fSeconds = fSeconds;
    }

    public Long getfSeconds()
    {
        return fSeconds;
    }
    public void setfRemarks(String fRemarks)
    {
        this.fRemarks = fRemarks;
    }

    public String getfRemarks()
    {
        return fRemarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("fComplainDealManSysSetId", getfComplainDealManSysSetId())
                .append("fType", getfType())
                .append("fDay", getfDay())
                .append("fHours", getfHours())
                .append("fMinutes", getfMinutes())
                .append("fSeconds", getfSeconds())
                .append("fRemarks", getfRemarks())
                .toString();
    }
}
