package com.zehong.system.domain;

import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 燃气投诉处置-评价对象 t_complain_deal_evaluate
 * 
 * @author zehong
 * @date 2024-06-14
 */
public class TComplainDealEvaluate extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 投诉处置评价id */
    private Long complainDealEvaluateId;

    /** 投诉处置id */
    private Long complainDealId;

    /** 评价内容 */
    @Excel(name = "评价内容")
    private String evaluateContent;

    /** 评分 */
    @Excel(name = "评分")
    private Long evaluateRate;

    public void setComplainDealEvaluateId(Long complainDealEvaluateId) 
    {
        this.complainDealEvaluateId = complainDealEvaluateId;
    }

    public Long getComplainDealEvaluateId() 
    {
        return complainDealEvaluateId;
    }
    public void setEvaluateContent(String evaluateContent) 
    {
        this.evaluateContent = evaluateContent;
    }

    public String getEvaluateContent() 
    {
        return evaluateContent;
    }
    public void setEvaluateRate(Long evaluateRate)
    {
        this.evaluateRate = evaluateRate;
    }

    public Long getEvaluateRate()
    {
        return evaluateRate;
    }

    public Long getComplainDealId() {
        return complainDealId;
    }

    public void setComplainDealId(Long complainDealId) {
        this.complainDealId = complainDealId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("complainDealEvaluateId", getComplainDealEvaluateId())
            .append("evaluateContent", getEvaluateContent())
            .append("evaluateRate", getEvaluateRate())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .toString();
    }
}
