package com.zehong.system.controller;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPatrolCheckIn;
import com.zehong.system.service.ITPatrolCheckInService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 巡检签到Controller
 * 
 * @author zehong
 * @date 2023-03-10
 */
@RestController
@RequestMapping("/system/in")
public class TPatrolCheckInController extends BaseController
{
    @Autowired
    private ITPatrolCheckInService tPatrolCheckInService;

    /**
     * 查询巡检签到列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TPatrolCheckIn tPatrolCheckIn)
    {
        startPage();
        List<TPatrolCheckIn> list = tPatrolCheckInService.selectTPatrolCheckInList(tPatrolCheckIn);
        return getDataTable(list);
    }

    /**
     * 导出巡检签到列表
     */
    @Log(title = "巡检签到", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPatrolCheckIn tPatrolCheckIn)
    {
        List<TPatrolCheckIn> list = tPatrolCheckInService.selectTPatrolCheckInList(tPatrolCheckIn);
        ExcelUtil<TPatrolCheckIn> util = new ExcelUtil<TPatrolCheckIn>(TPatrolCheckIn.class);
        return util.exportExcel(list, "巡检签到数据");
    }

    /**
     * 获取巡检签到详细信息
     */
    @GetMapping(value = "/{checkInId}")
    public AjaxResult getInfo(@PathVariable("checkInId") Long checkInId)
    {
        return AjaxResult.success(tPatrolCheckInService.selectTPatrolCheckInById(checkInId));
    }

    /**
     * 新增巡检签到
     */
    @Log(title = "巡检签到", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPatrolCheckIn tPatrolCheckIn)
    {
        return toAjax(tPatrolCheckInService.insertTPatrolCheckIn(tPatrolCheckIn));
    }

    /**
     * 修改巡检签到
     */
    @Log(title = "巡检签到", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPatrolCheckIn tPatrolCheckIn)
    {
        return toAjax(tPatrolCheckInService.updateTPatrolCheckIn(tPatrolCheckIn));
    }

    /**
     * 删除巡检签到
     */
    @Log(title = "巡检签到", businessType = BusinessType.DELETE)
	@DeleteMapping("/{checkInIds}")
    public AjaxResult remove(@PathVariable Long[] checkInIds)
    {
        return toAjax(tPatrolCheckInService.deleteTPatrolCheckInByIds(checkInIds));
    }
}
