package com.zehong.system.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEventReceive;
import com.zehong.system.service.ITEventReceiveService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 事件接报Controller
 * 
 * @author zehong
 * @date 2022-03-18
 */
@RestController
@RequestMapping("/system/receive")
public class TEventReceiveController extends BaseController
{
    @Autowired
    private ITEventReceiveService tEventReceiveService;

    /**
     * 查询事件接报列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TEventReceive tEventReceive)
    {
        startPage();
        List<TEventReceive> list = tEventReceiveService.selectTEventReceiveList(tEventReceive);
        return getDataTable(list);
    }

    /**
     * 导出事件接报列表
     */
    @Log(title = "事件接报", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEventReceive tEventReceive)
    {
        List<TEventReceive> list = tEventReceiveService.selectTEventReceiveList(tEventReceive);
        ExcelUtil<TEventReceive> util = new ExcelUtil<TEventReceive>(TEventReceive.class);
        return util.exportExcel(list, "事件接报数据");
    }

    /**
     * 获取事件接报详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(tEventReceiveService.selectTEventReceiveById(id));
    }

    /**
     * 新增事件接报
     */
    @Log(title = "事件接报", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEventReceive tEventReceive)
    {
        return toAjax(tEventReceiveService.insertTEventReceive(tEventReceive));
    }

    /**
     * 修改事件接报
     */
    @Log(title = "事件接报", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEventReceive tEventReceive)
    {
        return toAjax(tEventReceiveService.updateTEventReceive(tEventReceive));
    }

    /**
     * 删除事件接报
     */
    @Log(title = "事件接报", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(tEventReceiveService.deleteTEventReceiveByIds(ids));
    }
}
