package com.zehong.system.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEmergencyDevice;
import com.zehong.system.service.ITEmergencyDeviceService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急设备Controller
 * 
 * @author zehong
 * @date 2022-03-17
 */
@RestController
@RequestMapping("/system/device")
public class TEmergencyDeviceController extends BaseController
{
    @Autowired
    private ITEmergencyDeviceService tEmergencyDeviceService;

    /**
     * 查询应急设备列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TEmergencyDevice tEmergencyDevice)
    {
        startPage();
        List<TEmergencyDevice> list = tEmergencyDeviceService.selectTEmergencyDeviceList(tEmergencyDevice);
        return getDataTable(list);
    }

    /**
     * 导出应急设备列表
     */
    @Log(title = "应急设备", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEmergencyDevice tEmergencyDevice)
    {
        List<TEmergencyDevice> list = tEmergencyDeviceService.selectTEmergencyDeviceList(tEmergencyDevice);
        ExcelUtil<TEmergencyDevice> util = new ExcelUtil<TEmergencyDevice>(TEmergencyDevice.class);
        return util.exportExcel(list, "应急设备数据");
    }

    /**
     * 获取应急设备详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(tEmergencyDeviceService.selectTEmergencyDeviceById(id));
    }

    /**
     * 新增应急设备
     */
    @Log(title = "应急设备", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEmergencyDevice tEmergencyDevice)
    {
        return toAjax(tEmergencyDeviceService.insertTEmergencyDevice(tEmergencyDevice));
    }

    /**
     * 修改应急设备
     */
    @Log(title = "应急设备", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEmergencyDevice tEmergencyDevice)
    {
        return toAjax(tEmergencyDeviceService.updateTEmergencyDevice(tEmergencyDevice));
    }

    /**
     * 删除应急设备
     */
    @Log(title = "应急设备", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(tEmergencyDeviceService.deleteTEmergencyDeviceByIds(ids));
    }
}
