package com.zehong.web.controller.trainmanage;

import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TrainStat;
import com.zehong.system.domain.TrainStatDetail;
import com.zehong.system.service.ITTrainStatService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author geng
 * 培训统计
 */
@RestController
@RequestMapping("/train/stat")
public class TTrainStatController extends BaseController {

    @Autowired
    private ITTrainStatService itTrainStatService;

    /**
     * 培训统计查询
     * @param trainStat 查询条件
     * @return AjaxResult
     */
    @GetMapping("/trainStatData")
    public TableDataInfo trainStatData(TrainStat trainStat) {
        startPage();
        List<TrainStat> list = itTrainStatService.trainStatData(trainStat);
        return getDataTable(list);
    }

    /**
     * 培训统计详情
     * @param trainManageId 培训id
     * @return AjaxResult
     */
    @GetMapping("/trainStatDetail")
    public TableDataInfo trainStatDetail(Long trainManageId) {
        startPage();
        List<TrainStatDetail> list = itTrainStatService.trainStatDetail(trainManageId);
        return getDataTable(list);
    }

    /**
     * 培训详情导出
     * @param trainManageId 培训id
     * @return AjaxResult
     */
    @GetMapping("/export")
    public AjaxResult export(Long trainManageId){
        List<TrainStatDetail> list = itTrainStatService.trainStatDetail(trainManageId);
        ExcelUtil<TrainStatDetail> util = new ExcelUtil<>(TrainStatDetail.class);
        return util.exportExcel(list, "培训人员详情");
    }
}
