package com.zehong.web.controller.trainmanage;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TTrainPerson;
import com.zehong.system.service.ITTrainPersonService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 燃气培训人员Controller
 * 
 * @author zehong
 * @date 2023-04-22
 */
@RestController
@RequestMapping("/train/person")
public class TTrainPersonController extends BaseController
{
    @Autowired
    private ITTrainPersonService tTrainPersonService;

    /**
     * 查询燃气培训人员列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TTrainPerson tTrainPerson)
    {
        startPage();
        List<TTrainPerson> list = tTrainPersonService.selectTTrainPersonList(tTrainPerson);
        return getDataTable(list);
    }

    /**
     * 导出燃气培训人员列表
     */
    @Log(title = "燃气培训人员", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTrainPerson tTrainPerson)
    {
        List<TTrainPerson> list = tTrainPersonService.selectTTrainPersonList(tTrainPerson);
        ExcelUtil<TTrainPerson> util = new ExcelUtil<TTrainPerson>(TTrainPerson.class);
        return util.exportExcel(list, "燃气培训人员数据");
    }

    /**
     * 获取燃气培训人员详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tTrainPersonService.selectTTrainPersonById(id));
    }

    /**
     * 新增燃气培训人员
     */
    @Log(title = "燃气培训人员", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TTrainPerson tTrainPerson)
    {
        return toAjax(tTrainPersonService.insertTTrainPerson(tTrainPerson));
    }

    /**
     * 修改燃气培训人员
     */
    @Log(title = "燃气培训人员", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTrainPerson tTrainPerson)
    {
        return toAjax(tTrainPersonService.updateTTrainPerson(tTrainPerson));
    }

    /**
     * 删除燃气培训人员
     */
    @Log(title = "燃气培训人员", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tTrainPersonService.deleteTTrainPersonByIds(ids));
    }
}
