package com.zehong.web.controller.thirdbuild;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TConGasProInfor;
import com.zehong.system.service.ITConGasProInforService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 第三方施工-涉气第三方施工项目档案Controller
 * 
 * @author zehong
 * @date 2024-06-26
 */
@RestController
@RequestMapping("/third/project")
public class TConGasProInforController extends BaseController
{
    @Autowired
    private ITConGasProInforService tConGasProInforService;

    /**
     * 查询第三方施工-涉气第三方施工项目档案列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TConGasProInfor tConGasProInfor)
    {
        startPage();
        List<TConGasProInfor> list = tConGasProInforService.selectTConGasProInforList(tConGasProInfor);
        return getDataTable(list);
    }

    @GetMapping("/conGasProInfoList")
    public AjaxResult conGasProInfoList(TConGasProInfor tConGasProInfor){
        return AjaxResult.success(tConGasProInforService.selectTConGasProInforList(tConGasProInfor));
    }

    /**
     * 导出第三方施工-涉气第三方施工项目档案列表
     */
    @Log(title = "第三方施工-涉气第三方施工项目档案", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TConGasProInfor tConGasProInfor)
    {
        List<TConGasProInfor> list = tConGasProInforService.exportTConGasProInforList(tConGasProInfor);
        ExcelUtil<TConGasProInfor> util = new ExcelUtil<TConGasProInfor>(TConGasProInfor.class);
        AjaxResult ajaxResult = util.exportExcel(list, "第三方施工-涉气第三方施工项目档案数据");
        ExcelUtil.hiddencolumns.clear();
        return ajaxResult;
    }

    /**
     * 获取第三方施工-涉气第三方施工项目档案详细信息
     */
    @GetMapping(value = "/{fConGasProInforId}")
    public AjaxResult getInfo(@PathVariable("fConGasProInforId") Long fConGasProInforId)
    {
        return AjaxResult.success(tConGasProInforService.selectTConGasProInforById(fConGasProInforId));
    }

    /**
     * 新增第三方施工-涉气第三方施工项目档案
     */
    @Log(title = "第三方施工-涉气第三方施工项目档案", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TConGasProInfor tConGasProInfor)
    {
        return toAjax(tConGasProInforService.insertTConGasProInfor(tConGasProInfor));
    }

    /**
     * 修改第三方施工-涉气第三方施工项目档案
     */
    @Log(title = "第三方施工-涉气第三方施工项目档案", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TConGasProInfor tConGasProInfor)
    {
        return toAjax(tConGasProInforService.updateTConGasProInfor(tConGasProInfor));
    }

    /**
     * 删除第三方施工-涉气第三方施工项目档案
     */
    @Log(title = "第三方施工-涉气第三方施工项目档案", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fConGasProInforIds}")
    public AjaxResult remove(@PathVariable Long[] fConGasProInforIds)
    {
        return toAjax(tConGasProInforService.deleteTConGasProInforByIds(fConGasProInforIds));
    }

    /**
     * 上传第三方施工
     * @param fConGasProInforId 第三方施工id
     * @return
     */
    @GetMapping("/reportConGasProInfo")
    public AjaxResult reportConGasProInfo(Long fConGasProInforId){
        try{
            return toAjax(tConGasProInforService.reportConGasProInfo(fConGasProInforId));
        }catch (Exception e){
            logger.error("上传第三方施工接口异常=====",e);
            return AjaxResult.error("上传第三方施工接口异常");
        }
    }


    /**
     * 企业端上传第三方施工
     * @param fConGasProInforId 第三方施工id
     * @return
     */
    @GetMapping("/entReportConGasProInfo")
    public AjaxResult entReportConGasProInfo(Long fConGasProInforId){
        return toAjax(tConGasProInforService.entReportConGasProInfo(fConGasProInforId));
    }
}
