package com.zehong.web.controller.task;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TWorkTaskMember;
import com.zehong.system.service.ITWorkTaskMemberService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 【请填写功能名称】Controller
 * 
 * @author zehong
 * @date 2023-09-15
 */
@RestController
@RequestMapping("/system/member")
public class TWorkTaskMemberController extends BaseController
{
    @Autowired
    private ITWorkTaskMemberService tWorkTaskMemberService;

    /**
     * 查询【请填写功能名称】列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TWorkTaskMember tWorkTaskMember)
    {
        startPage();
        List<TWorkTaskMember> list = tWorkTaskMemberService.selectTWorkTaskMemberList(tWorkTaskMember);
        return getDataTable(list);
    }

    /**
     * 导出【请填写功能名称】列表
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TWorkTaskMember tWorkTaskMember)
    {
        List<TWorkTaskMember> list = tWorkTaskMemberService.selectTWorkTaskMemberList(tWorkTaskMember);
        ExcelUtil<TWorkTaskMember> util = new ExcelUtil<TWorkTaskMember>(TWorkTaskMember.class);
        return util.exportExcel(list, "【请填写功能名称】数据");
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tWorkTaskMemberService.selectTWorkTaskMemberById(id));
    }

    /**
     * 新增【请填写功能名称】
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TWorkTaskMember tWorkTaskMember)
    {
        return toAjax(tWorkTaskMemberService.insertTWorkTaskMember(tWorkTaskMember));
    }

    /**
     * 修改【请填写功能名称】
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TWorkTaskMember tWorkTaskMember)
    {
        return toAjax(tWorkTaskMemberService.updateTWorkTaskMember(tWorkTaskMember));
    }

    /**
     * 删除【请填写功能名称】
     */
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tWorkTaskMemberService.deleteTWorkTaskMemberByIds(ids));
    }
}
