package com.zehong.web.controller.system;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.ServletUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.domain.TTaskRecord;
import com.zehong.system.domain.TVehicleInfo;
import com.zehong.system.domain.TVehicleUseRecord;
import com.zehong.system.service.ITTaskRecordService;
import com.zehong.system.service.ITVehicleInfoService;
import com.zehong.system.service.ITVehicleUseRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

/**
 * 车辆使用记录Controller
 *
 * @author zehong
 * @date 2023-08-19
 */
@RestController
@RequestMapping("/system/record")
public class TVehicleUseRecordController extends BaseController
{
    @Autowired
    private ITVehicleUseRecordService tVehicleUseRecordService;
    @Autowired
    private TokenService tokenService;

    @Autowired
    private ITVehicleInfoService tVehicleInfoService;

    @Autowired
    private ITTaskRecordService tTaskRecordService;

    /**
     * 查询车辆使用记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TVehicleUseRecord tVehicleUseRecord)
    {
        startPage();
        List<TVehicleUseRecord> list = tVehicleUseRecordService.selectTVehicleUseRecordList(tVehicleUseRecord);
        return getDataTable(list);
    }

    /**
     * 微信小程序 获车辆使用记录详细信息
     * @param vehicleUseRecordId
     * @return
     */
    @GetMapping("/selectGet")
    public AjaxResult selectGetInfo(Long vehicleUseRecordId){
        TVehicleUseRecord tVehicleUseRecord = tVehicleUseRecordService.selectTVehicleUseRecordById(vehicleUseRecordId);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("tGasBottleTrackRecord", tVehicleUseRecord);
        return ajax;
    }


    /**
     * 导出车辆使用记录列表
     */
    @Log(title = "车辆使用记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TVehicleUseRecord tVehicleUseRecord)
    {
        List<TVehicleUseRecord> list = tVehicleUseRecordService.selectTVehicleUseRecordList(tVehicleUseRecord);
        ExcelUtil<TVehicleUseRecord> util = new ExcelUtil<TVehicleUseRecord>(TVehicleUseRecord.class);
        return util.exportExcel(list, "车辆使用记录数据");
    }

    /**
     * 获取车辆使用记录详细信息
     */
    @GetMapping(value = "/{vehicleUseRecordId}")
    public AjaxResult getInfo(@PathVariable("vehicleUseRecordId") Long vehicleUseRecordId)
    {
        return AjaxResult.success(tVehicleUseRecordService.selectTVehicleUseRecordById(vehicleUseRecordId));
    }

    /**
     * 新增车辆使用记录
     */
    @Log(title = "车辆使用记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TVehicleUseRecord tVehicleUseRecord)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        Long userId = loginUser.getUser().getUserId();
        tVehicleUseRecord.setVehicleUserId(userId);
        return toAjax(tVehicleUseRecordService.insertTVehicleUseRecord(tVehicleUseRecord));
    }

    /**
     * 微信小程序 车辆使用信息提交
     * @param tVehicleUseRecord
     * @return
     */
    @PostMapping("/addtVehicleUseRecord")
    public AjaxResult addtVehicleUseRecord(@RequestBody TVehicleUseRecord tVehicleUseRecord) throws ParseException {
        //修改车辆信息 使用状态和使用人
        TVehicleInfo tVehicleInfo=new TVehicleInfo();
        tVehicleInfo.setVehicleId(tVehicleUseRecord.getVehicleId());
        //设置使用人id
        tVehicleInfo.setVehicleUserId(tVehicleUseRecord.getVehicleUserId());
        //设置使用人姓名
        tVehicleInfo.setName(tVehicleUseRecord.getName());
        //设置使用状态
        tVehicleInfo.setOnState(tVehicleUseRecord.getOnState());
        //修改车辆管理信息表
        tVehicleInfoService.updateTVehicleInfo(tVehicleInfo);
        tVehicleUseRecordService.insertTVehicleUseRecord(tVehicleUseRecord);

        //设置任务记录信息
        TTaskRecord tTaskRecord=new TTaskRecord();
        //操作人id
        tTaskRecord.setOperator(Long.valueOf(tVehicleUseRecord.getVehicleUserId()));
        //工序
        tTaskRecord.setProcessesName("4");
        tTaskRecord.setCreateTime(new Date());
        tTaskRecord.setProcessesRelationId(tVehicleUseRecord.getVehicleUseRecordId());
        //任务记录表信息添加
        return toAjax(tTaskRecordService.insertTTaskRecord(tTaskRecord));
    }

    /**
     * 微信小程序  归还车辆接口
     */
    @PostMapping("/returningVehicle")
    public AjaxResult returningVehicle(@RequestBody TVehicleUseRecord tVehicleUseRecord) throws ParseException {
        //修改车辆信息 使用状态和使用人
        TVehicleInfo tVehicleInfo=new TVehicleInfo();
        tVehicleInfo.setVehicleId(tVehicleUseRecord.getVehicleId());
        //设置使用人id
        tVehicleInfo.setVehicleUserId(tVehicleUseRecord.getVehicleUserId());
        //设置使用人姓名
        tVehicleInfo.setName(tVehicleUseRecord.getName());
        //设置使用状态
        tVehicleInfo.setOnState(tVehicleUseRecord.getOnState());
        //修改车辆管理信息表
        return toAjax(tVehicleInfoService.updateTVehicleInfo(tVehicleInfo));
    }

    /**
     * 修改车辆使用记录
     */
    @Log(title = "车辆使用记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TVehicleUseRecord tVehicleUseRecord)
    {
        return toAjax(tVehicleUseRecordService.updateTVehicleUseRecord(tVehicleUseRecord));
    }

    /**
     * 删除车辆使用记录
     */
    @Log(title = "车辆使用记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{vehicleUseRecordIds}")
    public AjaxResult remove(@PathVariable Long[] vehicleUseRecordIds)
    {
        return toAjax(tVehicleUseRecordService.deleteTVehicleUseRecordByIds(vehicleUseRecordIds));
    }
}
