package com.zehong.web.controller.system;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSecurityDisseminate;
import com.zehong.system.service.ITSecurityDisseminateService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 安全宣传Controller
 * 
 * @author zehong
 * @date 2024-04-22
 */
@RestController
@RequestMapping("/system/disseminate")
public class TSecurityDisseminateController extends BaseController
{
    @Autowired
    private ITSecurityDisseminateService tSecurityDisseminateService;

    /**
     * 查询安全宣传列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TSecurityDisseminate tSecurityDisseminate)
    {
        startPage();
        List<TSecurityDisseminate> list = tSecurityDisseminateService.selectTSecurityDisseminateList(tSecurityDisseminate);
        return getDataTable(list);
    }

    /**
     * 导出安全宣传列表
     */
    @Log(title = "安全宣传", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSecurityDisseminate tSecurityDisseminate)
    {
        List<TSecurityDisseminate> list = tSecurityDisseminateService.selectTSecurityDisseminateList(tSecurityDisseminate);
        ExcelUtil<TSecurityDisseminate> util = new ExcelUtil<TSecurityDisseminate>(TSecurityDisseminate.class);
        return util.exportExcel(list, "安全宣传数据");
    }

    /**
     * 获取安全宣传详细信息
     */
    @GetMapping(value = "/{securityId}")
    public AjaxResult getInfo(@PathVariable("securityId") Long securityId)
    {
        return AjaxResult.success(tSecurityDisseminateService.selectTSecurityDisseminateById(securityId));
    }

    /**
     * 新增安全宣传
     */
    @Log(title = "安全宣传", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSecurityDisseminate tSecurityDisseminate)
    {
        return toAjax(tSecurityDisseminateService.insertTSecurityDisseminate(tSecurityDisseminate));
    }

    /**
     * 修改安全宣传
     */
    @Log(title = "安全宣传", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSecurityDisseminate tSecurityDisseminate)
    {
        return toAjax(tSecurityDisseminateService.updateTSecurityDisseminate(tSecurityDisseminate));
    }

    /**
     * 删除安全宣传
     */
    @Log(title = "安全宣传", businessType = BusinessType.DELETE)
	@DeleteMapping("/{securityIds}")
    public AjaxResult remove(@PathVariable Long[] securityIds)
    {
        return toAjax(tSecurityDisseminateService.deleteTSecurityDisseminateByIds(securityIds));
    }
}
