package com.zehong.web.controller.system;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPatrolWorkInfo;
import com.zehong.system.service.ITPatrolWorkInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 巡检任务Controller
 * 
 * @author zehong
 * @date 2023-08-05
 */
@RestController
@RequestMapping("/system/workinfo")
public class TPatrolWorkInfoController extends BaseController
{
    @Autowired
    private ITPatrolWorkInfoService tPatrolWorkInfoService;

    /**
     * 查询巡检任务列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TPatrolWorkInfo tPatrolWorkInfo)
    {
        startPage();
        List<TPatrolWorkInfo> list = tPatrolWorkInfoService.selectTPatrolWorkInfoList(tPatrolWorkInfo);
        return getDataTable(list);
    }

    /**
     * 导出巡检任务列表
     */
    @Log(title = "巡检任务", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPatrolWorkInfo tPatrolWorkInfo)
    {
        List<TPatrolWorkInfo> list = tPatrolWorkInfoService.selectTPatrolWorkInfoList(tPatrolWorkInfo);
        ExcelUtil<TPatrolWorkInfo> util = new ExcelUtil<TPatrolWorkInfo>(TPatrolWorkInfo.class);
        return util.exportExcel(list, "巡检任务数据");
    }

    /**
     * 获取巡检任务详细信息
     */
    @GetMapping(value = "/{workId}")
    public AjaxResult getInfo(@PathVariable("workId") Long workId)
    {
        return AjaxResult.success(tPatrolWorkInfoService.selectTPatrolWorkInfoById(workId));
    }

    /**
     * 新增巡检任务
     */
    @Log(title = "巡检任务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPatrolWorkInfo tPatrolWorkInfo)
    {
        return toAjax(tPatrolWorkInfoService.insertTPatrolWorkInfo(tPatrolWorkInfo));
    }

    /**
     * 修改巡检任务
     */
    @Log(title = "巡检任务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPatrolWorkInfo tPatrolWorkInfo)
    {
        return toAjax(tPatrolWorkInfoService.updateTPatrolWorkInfo(tPatrolWorkInfo));
    }

    /**
     * 删除巡检任务
     */
    @Log(title = "巡检任务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{workIds}")
    public AjaxResult remove(@PathVariable Long[] workIds)
    {
        return toAjax(tPatrolWorkInfoService.deleteTPatrolWorkInfoByIds(workIds));
    }
}
