package com.zehong.web.controller.supplybalance;

import java.util.List;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSupBalUsgDay;
import com.zehong.system.service.ITSupBalUsgDayService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 供需平衡-企业每日填报Controller
 * 
 * @author zehong
 * @date 2024-06-25
 */
@RestController
@RequestMapping("/supplyBalance/day")
public class TSupBalUsgDayController extends BaseController
{
    @Autowired
    private ITSupBalUsgDayService tSupBalUsgDayService;

    /**
     * 查询供需平衡-企业每日填报列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TSupBalUsgDay tSupBalUsgDay){
        startPage();
        if("-2".equals(SecurityUtils.getLoginUser().getUser().getDeptId())){
            tSupBalUsgDay.setfReportStatus("1");
        }
        List<TSupBalUsgDay> list = tSupBalUsgDayService.selectTSupBalUsgDayList(tSupBalUsgDay);
        return getDataTable(list);
    }

    /**
     * 导出供需平衡-企业每日填报列表
     */
    @Log(title = "供需平衡-企业每日填报", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSupBalUsgDay tSupBalUsgDay){
        LoginUser loginUser = SecurityUtils.getLoginUser();
        if(loginUser.getUser().getRoles().get(0).getRoleId()==3){
            tSupBalUsgDay.setfReportStatus("1");
        }
        List<TSupBalUsgDay> list = tSupBalUsgDayService.selectTSupBalUsgDayList(tSupBalUsgDay);
        ExcelUtil<TSupBalUsgDay> util = new ExcelUtil<TSupBalUsgDay>(TSupBalUsgDay.class);
        if(loginUser.getUser().getRoles().get(0).getRoleId()==5){
//            List<String> columns = new ArrayList<>();
//            columns.add("fReportStatus");
//            columns.add("fReportTime");
//            util.hideColumns(util.clazz,columns);
            ExcelUtil.hiddencolumns.add(24);
            ExcelUtil.hiddencolumns.add(25);
        }else{
//            List<String> columns = new ArrayList<>();
//            columns.add("fGovUploadStatus");
//            columns.add("fGovUploadTime");
//            util.hideColumns(util.clazz,columns);
            ExcelUtil.hiddencolumns.add(19);
            ExcelUtil.hiddencolumns.add(20);
        }
        AjaxResult ajaxResult = util.exportExcel(list, "供需平衡-企业每日填报数据");
        ExcelUtil.hiddencolumns.clear();
        return ajaxResult;
    }

    /**
     * 获取供需平衡-企业每日填报详细信息
     */
    @GetMapping(value = "/{fRepUsgDayId}")
    public AjaxResult getInfo(@PathVariable("fRepUsgDayId") Long fRepUsgDayId)
    {
        return AjaxResult.success(tSupBalUsgDayService.selectTSupBalUsgDayById(fRepUsgDayId));
    }

    /**
     * 新增供需平衡-企业每日填报
     */
    @Log(title = "供需平衡-企业每日填报", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSupBalUsgDay tSupBalUsgDay)
    {
        return toAjax(tSupBalUsgDayService.insertTSupBalUsgDay(tSupBalUsgDay));
    }

    /**
     * 修改供需平衡-企业每日填报
     */
    @Log(title = "供需平衡-企业每日填报", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSupBalUsgDay tSupBalUsgDay)
    {
        return toAjax(tSupBalUsgDayService.updateTSupBalUsgDay(tSupBalUsgDay));
    }

    /**
     * 删除供需平衡-企业每日填报
     */
    @Log(title = "供需平衡-企业每日填报", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fRepUsgDayIds}")
    public AjaxResult remove(@PathVariable Long[] fRepUsgDayIds)
    {
        return toAjax(tSupBalUsgDayService.deleteTSupBalUsgDayByIds(fRepUsgDayIds));
    }

    @GetMapping("/reportInfoList")
    public AjaxResult reportInfoList(TSupBalUsgDay tSupBalUsgDay){
        List<TSupBalUsgDay> list = tSupBalUsgDayService.selectTSupBalUsgDayList(tSupBalUsgDay);
        return AjaxResult.success(list);
    }

    /**
     * 获取上报信息
     * @param companyId 企业id
     * @param calendarDate 上报时间
     * @return
     */
    @GetMapping(value = "/getReportInfoByCompany")
    public AjaxResult getReportInfoByCompany(@RequestParam(value="companyId")String companyId, @RequestParam(value="calendarDate")String calendarDate){
        return AjaxResult.success(tSupBalUsgDayService.getReportInfoByCompany(companyId,calendarDate));
    }

    /**
     * 上传日用气量记录
     * @param fRepUsgDayId 监管记录主键
     * @return
     */
    @GetMapping("/reportSupBalGasDayRecInfo")
    public AjaxResult reportSupBalGasDayRecInfo(Long fRepUsgDayId){
        try{
            return toAjax(tSupBalUsgDayService.reportSupBalGasDayRecInfo(fRepUsgDayId));
        }catch (Exception e){
            logger.error("上传日用气量记录接口异常=====",e);
            return AjaxResult.error("上传日用气量记录接口异常");
        }
    }
}
