package com.zehong.web.controller.supervision;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInsSpotHazardRef;
import com.zehong.system.service.ITInsSpotHazardRefService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 监督检查-抽查隐患Controller
 * 
 * @author zehong
 * @date 2024-05-21
 */
@RestController
@RequestMapping("/supervision/spot")
public class TInsSpotHazardRefController extends BaseController
{
    @Autowired
    private ITInsSpotHazardRefService tInsSpotHazardRefService;

    /**
     * 查询监督检查-抽查隐患列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TInsSpotHazardRef tInsSpotHazardRef)
    {
        startPage();
        List<TInsSpotHazardRef> list = tInsSpotHazardRefService.selectTInsSpotHazardRefList(tInsSpotHazardRef);
        return getDataTable(list);
    }

    /**
     * 导出监督检查-抽查隐患列表
     */
    @Log(title = "监督检查-抽查隐患", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInsSpotHazardRef tInsSpotHazardRef)
    {
        List<TInsSpotHazardRef> list = tInsSpotHazardRefService.selectTInsSpotHazardRefList(tInsSpotHazardRef);
        ExcelUtil<TInsSpotHazardRef> util = new ExcelUtil<TInsSpotHazardRef>(TInsSpotHazardRef.class);
        return util.exportExcel(list, "监督检查-抽查隐患数据");
    }

    /**
     * 获取监督检查-抽查隐患详细信息
     */
    @GetMapping(value = "/{fInsSpotHazardRefId}")
    public AjaxResult getInfo(@PathVariable("fInsSpotHazardRefId") Long fInsSpotHazardRefId)
    {
        return AjaxResult.success(tInsSpotHazardRefService.selectTInsSpotHazardRefById(fInsSpotHazardRefId));
    }

    /**
     * 新增监督检查-抽查隐患
     */
    @Log(title = "监督检查-抽查隐患", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInsSpotHazardRef tInsSpotHazardRef)
    {
        return toAjax(tInsSpotHazardRefService.insertTInsSpotHazardRef(tInsSpotHazardRef));
    }

    /**
     * 修改监督检查-抽查隐患
     */
    @Log(title = "监督检查-抽查隐患", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInsSpotHazardRef tInsSpotHazardRef)
    {
        return toAjax(tInsSpotHazardRefService.updateTInsSpotHazardRef(tInsSpotHazardRef));
    }

    /**
     * 修改监督检查-抽查隐患-处置
     */
    @Log(title = "监督检查-抽查隐患", businessType = BusinessType.UPDATE)
    @PutMapping(value = "/disposeOfInsSpotHazardRef")
    public AjaxResult disposeOfInsSpotHazardRef(@RequestBody TInsSpotHazardRef tInsSpotHazardRef)
    {
        return toAjax(tInsSpotHazardRefService.disposeOfInsSpotHazardRef(tInsSpotHazardRef));
    }

    /**
     * 删除监督检查-抽查隐患
     */
    @Log(title = "监督检查-抽查隐患", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fInsSpotHazardRefIds}")
    public AjaxResult remove(@PathVariable Long[] fInsSpotHazardRefIds)
    {
        return toAjax(tInsSpotHazardRefService.deleteTInsSpotHazardRefByIds(fInsSpotHazardRefIds));
    }
}
