package com.zehong.web.controller.supervision;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInsRecInfor;
import com.zehong.system.service.ITInsRecInforService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 监督检查-检查记录Controller
 * 
 * @author zehong
 * @date 2024-05-20
 */
@RestController
@RequestMapping("/supervision/record")
public class TInsRecInforController extends BaseController
{
    @Autowired
    private ITInsRecInforService tInsRecInforService;

    /**
     * 查询监督检查-检查记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TInsRecInfor tInsRecInfor)
    {
        startPage();
        List<TInsRecInfor> list = tInsRecInforService.selectTInsRecInforList(tInsRecInfor);
        return getDataTable(list);
    }

    /**
     * 所有记录
     * @param tInsRecInfor
     * @return
     */
    @GetMapping("/recordList")
    public AjaxResult recordList(TInsRecInfor tInsRecInfor){
        List<TInsRecInfor> list = tInsRecInforService.selectTInsRecInforList(tInsRecInfor);
        return AjaxResult.success(list);
    }

    /**
     * 导出监督检查-检查记录列表
     */
    @Log(title = "监督检查-检查记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInsRecInfor tInsRecInfor)
    {
        List<TInsRecInfor> list = tInsRecInforService.selectTInsRecInforList(tInsRecInfor);
        ExcelUtil<TInsRecInfor> util = new ExcelUtil<TInsRecInfor>(TInsRecInfor.class);
        return util.exportExcel(list, "监督检查-检查记录数据");
    }

    /**
     * 获取监督检查-检查记录详细信息
     */
    @GetMapping(value = "/{fInsRecInforId}")
    public AjaxResult getInfo(@PathVariable("fInsRecInforId") Long fInsRecInforId)
    {
        return AjaxResult.success(tInsRecInforService.selectTInsRecInforById(fInsRecInforId));
    }

    /**
     * 新增监督检查-检查记录
     */
    @Log(title = "监督检查-检查记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInsRecInfor tInsRecInfor)
    {
        return toAjax(tInsRecInforService.insertTInsRecInfor(tInsRecInfor));
    }

    /**
     * 修改监督检查-检查记录
     */
    @Log(title = "监督检查-检查记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInsRecInfor tInsRecInfor)
    {
        return toAjax(tInsRecInforService.updateTInsRecInfor(tInsRecInfor));
    }

    /**
     * 删除监督检查-检查记录
     */
    @Log(title = "监督检查-检查记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fInsRecInforIds}")
    public AjaxResult remove(@PathVariable Long[] fInsRecInforIds)
    {
        return toAjax(tInsRecInforService.deleteTInsRecInforByIds(fInsRecInforIds));
    }

    /**
     * 上传检查记录
     * @param fInsRecInforId 检查记录id
     * @return
     */
    @GetMapping("/reportRecInfo")
    public AjaxResult reportRecInfo(Long fInsRecInforId){
        try{
            return toAjax(tInsRecInforService.reportRecInfo(fInsRecInforId));
        }catch (Exception e){
            logger.error("上传检查记录接口异常=====",e);
            return AjaxResult.error("上传检查记录接口异常");
        }
    }
}
