package com.zehong.web.controller.supervision;

import java.util.List;

import com.zehong.common.exception.CustomException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TInsHazRef;
import com.zehong.system.service.ITInsHazRefService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 监督检查-监督检查发现隐患及整改，执法结果Controller
 * 
 * @author zehong
 * @date 2024-05-21
 */
@RestController
@RequestMapping("/supervision/rectification")
public class TInsHazRefController extends BaseController
{
    @Autowired
    private ITInsHazRefService tInsHazRefService;

    /**
     * 查询监督检查-监督检查发现隐患及整改，执法结果列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TInsHazRef tInsHazRef)
    {
        startPage();
        List<TInsHazRef> list = tInsHazRefService.selectTInsHazRefList(tInsHazRef);
        return getDataTable(list);
    }

    /**
     * 导出监督检查-监督检查发现隐患及整改，执法结果列表
     */
    @Log(title = "监督检查-监督检查发现隐患及整改，执法结果", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TInsHazRef tInsHazRef)
    {
        List<TInsHazRef> list = tInsHazRefService.selectTInsHazRefList(tInsHazRef);
        ExcelUtil<TInsHazRef> util = new ExcelUtil<TInsHazRef>(TInsHazRef.class);
        return util.exportExcel(list, "监督检查-监督检查发现隐患及整改，执法结果数据");
    }

    /**
     * 获取监督检查-监督检查发现隐患及整改，执法结果详细信息
     */
    @GetMapping(value = "/{fInsHazRefId}")
    public AjaxResult getInfo(@PathVariable("fInsHazRefId") Long fInsHazRefId)
    {
        return AjaxResult.success(tInsHazRefService.selectTInsHazRefById(fInsHazRefId));
    }

    /**
     * 新增监督检查-监督检查发现隐患及整改，执法结果
     */
    @Log(title = "监督检查-监督检查发现隐患及整改，执法结果", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TInsHazRef tInsHazRef)
    {
        return toAjax(tInsHazRefService.insertTInsHazRef(tInsHazRef));
    }

    /**
     * 修改监督检查-监督检查发现隐患及整改，执法结果
     */
    @Log(title = "监督检查-监督检查发现隐患及整改，执法结果", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TInsHazRef tInsHazRef)
    {
        return toAjax(tInsHazRefService.updateTInsHazRef(tInsHazRef));
    }

    /**
     * 删除监督检查-监督检查发现隐患及整改，执法结果
     */
    @Log(title = "监督检查-监督检查发现隐患及整改，执法结果", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fInsHazRefIds}")
    public AjaxResult remove(@PathVariable Long[] fInsHazRefIds)
    {
        return toAjax(tInsHazRefService.deleteTInsHazRefByIds(fInsHazRefIds));
    }


    /**
     * 上传监督检查发现隐患及整改、执法结果
     * @param fInsHazRefId 结果id
     * @return
     */
    @GetMapping("/reportHazRefInfo")
    public AjaxResult reportHazRefInfo(Long fInsHazRefId){
        try{
            return toAjax(tInsHazRefService.reportHazRefInfo(fInsHazRefId));
        }catch (Exception e){
            logger.error("上传监督检查发现隐患及整改、执法结果接口异常=====",e);
            return AjaxResult.error("上传监督检查发现隐患及整改、执法结果接口异常");
        }
    }

    /**
     * 根据检查记录上传隐患
     * @param checkCode
     * @return
     */
    @GetMapping("/reportHazRefInfoByCheckCode")
    public AjaxResult reportHazRefInfoByCheckCode(String checkCode){
        try {
            return toAjax(tInsHazRefService.reportHazRefInfoByCheckCode(checkCode));
        }catch (CustomException e){
            logger.error("根据检查编码上传隐患业务异常=====",e);
            return AjaxResult.error(e.getMessage());
        }catch (Exception e){
            logger.error("根据检查编码上传隐患接口异常=====",e);
            return AjaxResult.error("上传隐患接口异常");
        }
    }
}
