package com.zehong.web.controller.supervise;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TUserManageVillage;
import com.zehong.system.service.ITUserManageVillageService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 基本信息维护-用户管理-居住区(村庄)Controller
 * 
 * @author zehong
 * @date 2024-08-27
 */
@RestController
@RequestMapping("/system/village")
public class TUserManageVillageController extends BaseController
{
    @Autowired
    private ITUserManageVillageService tUserManageVillageService;

    /**
     * 查询基本信息维护-用户管理-居住区(村庄)列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TUserManageVillage tUserManageVillage)
    {
        startPage();
        List<TUserManageVillage> list = tUserManageVillageService.selectTUserManageVillageList(tUserManageVillage);
        return getDataTable(list);
    }

    /**
     * 查询基本信息维护-用户管理-居住区(村庄)列表-无分页
     */
    @GetMapping("/noPagelist")
    public List<TUserManageVillage> noPagelist(TUserManageVillage tUserManageVillage)
    {
        return tUserManageVillageService.selectTUserManageVillageList(tUserManageVillage);
    }



    /**
     * 导出基本信息维护-用户管理-居住区(村庄)列表
     */
    @Log(title = "基本信息维护-用户管理-居住区(村庄)", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TUserManageVillage tUserManageVillage)
    {
        List<TUserManageVillage> list = tUserManageVillageService.exportTUserManageVillageList(tUserManageVillage);
        ExcelUtil<TUserManageVillage> util = new ExcelUtil<TUserManageVillage>(TUserManageVillage.class);
        return util.exportExcel(list, "基本信息维护-用户管理-居住区(村庄)数据");
    }

    /**
     * 获取基本信息维护-用户管理-居住区(村庄)详细信息
     */
    @GetMapping(value = "/{fVillageId}")
    public AjaxResult getInfo(@PathVariable("fVillageId") Long fVillageId)
    {
        return AjaxResult.success(tUserManageVillageService.selectTUserManageVillageById(fVillageId));
    }

    /**
     * 新增基本信息维护-用户管理-居住区(村庄)
     */
    @Log(title = "基本信息维护-用户管理-居住区(村庄)", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TUserManageVillage tUserManageVillage)
    {
        return toAjax(tUserManageVillageService.insertTUserManageVillage(tUserManageVillage));
    }

    /**
     * 修改基本信息维护-用户管理-居住区(村庄)
     */
    @Log(title = "基本信息维护-用户管理-居住区(村庄)", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TUserManageVillage tUserManageVillage)
    {
        return toAjax(tUserManageVillageService.updateTUserManageVillage(tUserManageVillage));
    }

    /**
     * 删除基本信息维护-用户管理-居住区(村庄)
     */
    @Log(title = "基本信息维护-用户管理-居住区(村庄)", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fVillageIds}")
    public AjaxResult remove(@PathVariable Long[] fVillageIds)
    {
        return toAjax(tUserManageVillageService.deleteTUserManageVillageByIds(fVillageIds));
    }
}
