package com.zehong.web.controller.specialist;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TProAppInforBrowse;
import com.zehong.system.service.ITProAppInforBrowseService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 行业专家库-专家库浏览Controller
 * 
 * @author zehong
 * @date 2024-05-08
 */
@RestController
@RequestMapping("/specialist/browse")
public class TProAppInforBrowseController extends BaseController
{
    @Autowired
    private ITProAppInforBrowseService tProAppInforBrowseService;

    /**
     * 查询行业专家库-专家库浏览列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TProAppInforBrowse tProAppInforBrowse)
    {
        startPage();
        List<TProAppInforBrowse> list = tProAppInforBrowseService.selectTProAppInforBrowseList(tProAppInforBrowse);
        return getDataTable(list);
    }

    /**
     * 导出行业专家库-专家库浏览列表
     */
    @Log(title = "行业专家库-专家库浏览", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TProAppInforBrowse tProAppInforBrowse)
    {
        List<TProAppInforBrowse> list = tProAppInforBrowseService.selectTProAppInforBrowseList(tProAppInforBrowse);
        ExcelUtil<TProAppInforBrowse> util = new ExcelUtil<TProAppInforBrowse>(TProAppInforBrowse.class);
        return util.exportExcel(list, "行业专家库-专家库浏览数据");
    }

    /**
     * 获取行业专家库-专家库浏览详细信息
     */
    @GetMapping(value = "/{fProAppInforId}")
    public AjaxResult getInfo(@PathVariable("fProAppInforId") Long fProAppInforId)
    {
        return AjaxResult.success(tProAppInforBrowseService.selectTProAppInforBrowseById(fProAppInforId));
    }

    /**
     * 新增行业专家库-专家库浏览
     */
    @Log(title = "行业专家库-专家库浏览", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TProAppInforBrowse tProAppInforBrowse)
    {
        return toAjax(tProAppInforBrowseService.insertTProAppInforBrowse(tProAppInforBrowse));
    }

    /**
     * 修改行业专家库-专家库浏览
     */
    @Log(title = "行业专家库-专家库浏览", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TProAppInforBrowse tProAppInforBrowse)
    {
        return toAjax(tProAppInforBrowseService.updateTProAppInforBrowse(tProAppInforBrowse));
    }

    /**
     * 删除行业专家库-专家库浏览
     */
    @Log(title = "行业专家库-专家库浏览", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fProAppInforIds}")
    public AjaxResult remove(@PathVariable Long[] fProAppInforIds)
    {
        return toAjax(tProAppInforBrowseService.deleteTProAppInforBrowseByIds(fProAppInforIds));
    }
}
