package com.zehong.web.controller.operationMonitor;

import java.util.List;

import com.zehong.system.domain.TVehicleLocationInfo;
import com.zehong.system.service.ITVehicleLocationInfoService;
import io.jsonwebtoken.lang.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TVehicleInfo;
import com.zehong.system.service.ITVehicleInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 燃气车辆信息Controller
 *
 * @author zehong
 * @date 2022-03-17
 */
@RestController
@RequestMapping("/system/vehicleInfo")
public class TVehicleInfoController extends BaseController
{
    @Autowired
    private ITVehicleInfoService tVehicleInfoService;

    @Autowired
    private ITVehicleLocationInfoService itVehicleLocationInfoService;

    @Autowired
    private ITVehicleLocationInfoService tVehicleLocationInfoService;

    /**
     * 查询燃气车辆信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TVehicleInfo tVehicleInfo)
    {
        startPage();
        List<TVehicleInfo> list = tVehicleInfoService.selectTVehicleInfoList(tVehicleInfo);
        return getDataTable(list);
    }

    /**
     * 查询车辆最终位置
     * @param vehicleId 车辆信息id
     * @return
     */
    @GetMapping("/getLastLocation")
    public AjaxResult getLastLocation(@RequestParam(value="vehicleId") Long vehicleId){
        //获取车辆信息
        TVehicleInfo tVehicleInfo = tVehicleInfoService.selectTVehicleInfoById(vehicleId);
        //获取最后位置信息
        TVehicleLocationInfo tVehicleLocationInfo = new TVehicleLocationInfo();
        tVehicleLocationInfo.setCarNum(tVehicleInfo.getCarNum());
        tVehicleLocationInfo.setLast(true);
        List<TVehicleLocationInfo> tVehicleLocationInfoList=itVehicleLocationInfoService.selectTVehicleLocationInfoList(tVehicleLocationInfo);
        //车辆最后位置
        if(!Collections.isEmpty(tVehicleLocationInfoList) && tVehicleLocationInfoList.size() > 0){
            tVehicleInfo.setLongitude(tVehicleLocationInfoList.get(0).getLongitude());
            tVehicleInfo.setLatitude(tVehicleLocationInfoList.get(0).getLatitude());
        }
        return AjaxResult.success(tVehicleInfo);
    }

    /**
     * 导出燃气车辆信息列表
     */
    @Log(title = "燃气车辆信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TVehicleInfo tVehicleInfo)
    {
        List<TVehicleInfo> list = tVehicleInfoService.selectTVehicleInfoList(tVehicleInfo);
        ExcelUtil<TVehicleInfo> util = new ExcelUtil<TVehicleInfo>(TVehicleInfo.class);
        return util.exportExcel(list, "燃气车辆信息数据");
    }



    /**
     * 获取燃气车辆信息详细信息
     */
    @GetMapping(value = "/{vehicleId}")
    public AjaxResult getInfo(@PathVariable("vehicleId") Long vehicleId)
    {
        return AjaxResult.success(tVehicleInfoService.selectTVehicleInfoById(vehicleId));
    }

    /**
     * 新增燃气车辆信息
     */
    @Log(title = "燃气车辆信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TVehicleInfo tVehicleInfo)
    {
        return toAjax(tVehicleInfoService.insertTVehicleInfo(tVehicleInfo));
    }

    /**
     * 修改燃气车辆信息
     */
    @Log(title = "燃气车辆信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TVehicleInfo tVehicleInfo)
    {
        return toAjax(tVehicleInfoService.updateTVehicleInfo(tVehicleInfo));
    }

    /**
     * 删除燃气车辆信息
     */
    @Log(title = "燃气车辆信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{vehicleIds}")
    public AjaxResult remove(@PathVariable Long[] vehicleIds)
    {
        return toAjax(tVehicleInfoService.deleteTVehicleInfoByIds(vehicleIds));
    }
}
