package com.zehong.web.controller.lpgRegulation;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TLpgAirChargeFiles;
import com.zehong.system.service.ITLpgAirChargeFilesService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * 液化石油气-充装记录Controller
 * 
 * @author zehong
 * @date 2024-07-09
 */
@RestController
@RequestMapping("/lpg/airchargefiles")
public class TLpgAirChargeFilesController extends BaseController
{
    @Autowired
    private ITLpgAirChargeFilesService tLpgAirChargeFilesService;

    /**
     * 查询液化石油气-充装记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TLpgAirChargeFiles tLpgAirChargeFiles)
    {
        startPage();
        List<TLpgAirChargeFiles> list = tLpgAirChargeFilesService.selectTLpgAirChargeFilesList(tLpgAirChargeFiles);
        return getDataTable(list);
    }

    /**
     * 导出液化石油气-充装记录列表
     */
    @Log(title = "液化石油气-充装记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TLpgAirChargeFiles tLpgAirChargeFiles)
    {
        List<TLpgAirChargeFiles> list = tLpgAirChargeFilesService.queryAllForExport(tLpgAirChargeFiles);
        ExcelUtil<TLpgAirChargeFiles> util = new ExcelUtil<TLpgAirChargeFiles>(TLpgAirChargeFiles.class);
        return util.exportExcel(list, "液化石油气-充装记录数据");
    }

    /**
     * 获取液化石油气-充装记录详细信息
     */
    @GetMapping(value = "/{fGasAirChargeId}")
    public AjaxResult getInfo(@PathVariable("fGasAirChargeId") Long fGasAirChargeId)
    {
        return AjaxResult.success(tLpgAirChargeFilesService.selectTLpgAirChargeFilesById(fGasAirChargeId));
    }

    /**
     * 新增液化石油气-充装记录
     */
    @Log(title = "液化石油气-充装记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TLpgAirChargeFiles tLpgAirChargeFiles)
    {
        return toAjax(tLpgAirChargeFilesService.insertTLpgAirChargeFiles(tLpgAirChargeFiles));
    }

    /**
     * 修改液化石油气-充装记录
     */
    @Log(title = "液化石油气-充装记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TLpgAirChargeFiles tLpgAirChargeFiles)
    {
        return toAjax(tLpgAirChargeFilesService.updateTLpgAirChargeFiles(tLpgAirChargeFiles));
    }

    /**
     * 删除液化石油气-充装记录
     */
    @Log(title = "液化石油气-充装记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fGasAirChargeIds}")
    public AjaxResult remove(@PathVariable Long[] fGasAirChargeIds)
    {
        return toAjax(tLpgAirChargeFilesService.deleteTLpgAirChargeFilesByIds(fGasAirChargeIds));
    }


    /**
     * 模版下载
     * @return r
     */
    @GetMapping("/importTemplate")
    public AjaxResult importTemplate(){
        ExcelUtil<TLpgAirChargeFiles> util = new ExcelUtil<>(TLpgAirChargeFiles.class);
        return util.importTemplateExcel("充装记录数据");
    }

    /**
     * 文件导入
     * @param file f
     * @param updateSupport u
     * @return r
     * @throws Exception r
     */
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport, HttpServletResponse response) throws Exception
    {

        ExcelUtil<TLpgAirChargeFiles> util = new ExcelUtil<>(TLpgAirChargeFiles.class);
        List<TLpgAirChargeFiles> XmbhList = util.importExcel(file.getInputStream());

        Map<String, Object> map = tLpgAirChargeFilesService.importLpgAirChargeFileInfo(XmbhList, updateSupport, response);
        return AjaxResult.success(map);
    }

}
