package com.zehong.web.controller.government;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.service.GovernmentSupervisionInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import java.util.HashMap;
import java.util.Map;

/**
 * @author geng
 * 政府监管平台信息
 */
@RestController
@RequestMapping("/government/supervision")
public class GovernmentSupervisionInfoController {

    private static final Logger log = LoggerFactory.getLogger(GovernmentSupervisionInfoController.class);

    @Autowired
    private GovernmentSupervisionInfoService governmentSupervisionInfoService;

    /**
     * 获取市级行政区
     * @param updateTime 大于等于更新时间的数据 yyyy-MM-dd HH:mm:ss
     * @param pageIndex 页码
     * @param pageSize 每页记录数，取值范围: 1~1000
     * @return
     */
    @GetMapping(value = "/getCity")
    public AjaxResult getCity(@RequestParam(value = "updateTime") String updateTime, @RequestParam(value = "pageIndex") Integer pageIndex, @RequestParam(value = "pageSize") Integer pageSize){

        try {
            Map<String,Object> map = new HashMap<>();
            map.put("updateTime",updateTime);
            map.put("pageIndex",pageIndex);
            map.put("pageSize",pageSize);
            JSONObject json = governmentSupervisionInfoService.getCity(map);
            return AjaxResult.success(json);
        } catch (Exception e) {
            log.error("获取市级行政区失败",e);
            return AjaxResult.error("获取市级行政区失败");
        }
    }

    /**
     * 获取县级行政区
     * @param updateTime 大于等于更新时间的数据 yyyy-MM-dd HH:mm:ss
     * @param pageIndex 页码
     * @param pageSize 每页记录数，取值范围: 1~1000
     * @return
     */
    @GetMapping(value = "/getCounty")
    public AjaxResult getCounty(@RequestParam(value = "updateTime") String updateTime, @RequestParam(value = "pageIndex") Integer pageIndex, @RequestParam(value = "pageSize") Integer pageSize){

        try {
            Map<String,Object> map = new HashMap<>();
            map.put("updateTime",updateTime);
            map.put("pageIndex",pageIndex);
            map.put("pageSize",pageSize);
            JSONObject json = governmentSupervisionInfoService.getCounty(map);
            return AjaxResult.success(json);
        } catch (Exception e) {
            log.error("获取县级行政区失败",e);
            return AjaxResult.error("获取县级行政区失败");
        }
    }

    /**
     * 获取乡级行政区
     * @param updateTime 大于等于更新时间的数据 yyyy-MM-dd HH:mm:ss
     * @param pageIndex 页码
     * @param pageSize 每页记录数，取值范围: 1~1000
     * @return
     */
    @GetMapping(value = "/getTown")
    public AjaxResult getTown(@RequestParam(value = "updateTime") String updateTime, @RequestParam(value = "pageIndex") Integer pageIndex, @RequestParam(value = "pageSize") Integer pageSize){

        try {
            Map<String,Object> map = new HashMap<>();
            map.put("updateTime",updateTime);
            map.put("pageIndex",pageIndex);
            map.put("pageSize",pageSize);
            JSONObject json = governmentSupervisionInfoService.getTown(map);
            return AjaxResult.success(json);
        } catch (Exception e) {
            log.error("获取乡级行政区失败",e);
            return AjaxResult.error("获取乡级行政区失败");
        }
    }

    /**
     * 获取村级行政区
     * @param updateTime 大于等于更新时间的数据 yyyy-MM-dd HH:mm:ss
     * @param pageIndex 页码
     * @param pageSize 每页记录数，取值范围: 1~1000
     * @return
     */
    @GetMapping(value = "/getVillage")
    public AjaxResult getVillage(@RequestParam(value = "updateTime") String updateTime, @RequestParam(value = "pageIndex") Integer pageIndex, @RequestParam(value = "pageSize") Integer pageSize){

        try {
            Map<String,Object> map = new HashMap<>();
            map.put("updateTime",updateTime);
            map.put("pageIndex",pageIndex);
            map.put("pageSize",pageSize);
            JSONObject json = governmentSupervisionInfoService.getVillage(map);
            return AjaxResult.success(json);
        } catch (Exception e) {
            log.error("获取村级行政区失败",e);
            return AjaxResult.error("获取村级行政区失败");
        }
    }

    /**
     * 获取行业专家档案
     * @param updateTime 大于等于更新时间的数据 yyyy-MM-dd HH:mm:ss
     * @param pageIndex 页码
     * @param pageSize 每页记录数，取值范围: 1~1000
     * @return
     */
    @GetMapping(value = "/getProfessorInfo")
    public AjaxResult getProfessorInfo(@RequestParam(value = "updateTime") String updateTime, @RequestParam(value = "pageIndex") Integer pageIndex, @RequestParam(value = "pageSize") Integer pageSize){

        try {
            Map<String,Object> map = new HashMap<>();
            map.put("updateTime",updateTime);
            map.put("pageIndex",pageIndex);
            map.put("pageSize",pageSize);
            JSONObject json = governmentSupervisionInfoService.getProfessorInfo(map);
            return AjaxResult.success(json);
        } catch (Exception e) {
            log.error("获取行业专家档案失败",e);
            return AjaxResult.error("获取行业专家档案失败");
        }
    }

    /**
     * 获取专家行为档案
     * @param updateTime 大于等于更新时间的数据 yyyy-MM-dd HH:mm:ss
     * @param pageIndex 页码
     * @param pageSize 每页记录数，取值范围: 1~1000
     * @return
     */
    @GetMapping(value = "/getBehaviour")
    public AjaxResult getBehaviour(@RequestParam(value = "updateTime") String updateTime,@RequestParam(value = "pageIndex") Integer pageIndex,@RequestParam(value = "pageSize") Integer pageSize){
        try {
            Map<String,Object> map = new HashMap<>();
            map.put("updateTime",updateTime);
            map.put("pageIndex",pageIndex);
            map.put("pageSize",pageSize);
            JSONObject json = governmentSupervisionInfoService.getBehaviour(map);
            return AjaxResult.success(json);
        } catch (Exception e) {
            log.error("获取行业专家档案失败",e);
            return AjaxResult.error("获取专家行为档案失败");
        }
    }

    /**
     * 获取检查任务
     * @param updateTime 大于等于更新时间的数据 yyyy-MM-dd HH:mm:ss
     * @param pageIndex 页码
     * @param pageSize 每页记录数，取值范围: 1~1000
     * @return
     */
    @GetMapping(value = "/getTask")
    public AjaxResult getTask(@RequestParam(value = "updateTime") String updateTime,@RequestParam(value = "pageIndex") Integer pageIndex,@RequestParam(value = "pageSize") Integer pageSize){
        try {
            Map<String,Object> map = new HashMap<>();
            map.put("updateTime",updateTime);
            map.put("pageIndex",pageIndex);
            map.put("pageSize",pageSize);
            JSONObject json = governmentSupervisionInfoService.getTask(map);
            if(null == json || !"0".equals(json.getString("resultCode"))) return null == json ? AjaxResult.error("获取检查任务失败") : AjaxResult.error(json.getString("resultMessage"));
            return AjaxResult.success(json);
        } catch (Exception e) {
            log.error("获取检查任务失败",e);
            return AjaxResult.error("获取检查任务失败");
        }
    }


    /**
     * 获取检查范围
     * @param updateTime 大于等于更新时间的数据 yyyy-MM-dd HH:mm:ss
     * @param pageIndex 页码
     * @param pageSize 每页记录数，取值范围: 1~1000
     * @return
     */
    @GetMapping(value = "/getScope")
    public AjaxResult getScope(@RequestParam(value = "updateTime") String updateTime,@RequestParam(value = "pageIndex") Integer pageIndex,@RequestParam(value = "pageSize") Integer pageSize){
        try {
            Map<String,Object> map = new HashMap<>();
            map.put("updateTime",updateTime);
            map.put("pageIndex",pageIndex);
            map.put("pageSize",pageSize);
            JSONObject json = governmentSupervisionInfoService.getScope(map);
            return AjaxResult.success(json);
        } catch (Exception e) {
            log.error("获取检查范围失败",e);
            return AjaxResult.error("获取检查范围失败");
        }
    }

    /**
     * 获取检查项
     * @param updateTime 大于等于更新时间的数据 yyyy-MM-dd HH:mm:ss
     * @param pageIndex 页码
     * @param pageSize 每页记录数，取值范围: 1~1000
     * @return
     */
    @GetMapping(value = "/getInspectList")
    public AjaxResult getInspectList(@RequestParam(value = "updateTime") String updateTime,@RequestParam(value = "pageIndex") Integer pageIndex,@RequestParam(value = "pageSize") Integer pageSize){
        try {
            Map<String,Object> map = new HashMap<>();
            map.put("updateTime",updateTime);
            map.put("pageIndex",pageIndex);
            map.put("pageSize",pageSize);
            JSONObject json = governmentSupervisionInfoService.getInspectList(map);
            return AjaxResult.success(json);
        } catch (Exception e) {
            log.error("获取检查项失败",e);
            return AjaxResult.error("获取检查项失败");
        }
    }


    /**
     * 获取调查项
     * @param updateTime 大于等于更新时间的数据 yyyy-MM-dd HH:mm:ss
     * @param pageIndex 页码
     * @param pageSize 每页记录数，取值范围: 1~1000
     * @return
     */
    @GetMapping(value = "/getSurveyList")
    public AjaxResult getSurveyList(@RequestParam(value = "updateTime") String updateTime,@RequestParam(value = "pageIndex") Integer pageIndex,@RequestParam(value = "pageSize") Integer pageSize){
        try {
            Map<String,Object> map = new HashMap<>();
            map.put("updateTime",updateTime);
            map.put("pageIndex",pageIndex);
            map.put("pageSize",pageSize);
            JSONObject json = governmentSupervisionInfoService.getSurveyList(map);
            return AjaxResult.success(json);
        } catch (Exception e) {
            log.error("获取调查项失败",e);
            return AjaxResult.error("获取调查项失败");
        }
    }


    /**
     * 获取抽查隐患
     * @param updateTime 大于等于更新时间的数据 yyyy-MM-dd HH:mm:ss
     * @param pageIndex 页码
     * @param pageSize 每页记录数，取值范围: 1~1000
     * @return
     */
    @GetMapping(value = "/getSpotHazard")
    public AjaxResult getSpotHazard (@RequestParam(value = "updateTime") String updateTime,@RequestParam(value = "pageIndex") Integer pageIndex,@RequestParam(value = "pageSize") Integer pageSize){
        try {
            Map<String,Object> map = new HashMap<>();
            map.put("updateTime",updateTime);
            map.put("pageIndex",pageIndex);
            map.put("pageSize",pageSize);
            JSONObject json = governmentSupervisionInfoService.getSpotHazard(map);
            return AjaxResult.success(json);
        } catch (Exception e) {
            log.error("获取抽查隐患失败",e);
            return AjaxResult.error("获取抽查隐患失败");
        }
    }

    /**
     * 获取隐患分类分级标准
     * @param updateTime 大于等于更新时间的数据 yyyy-MM-dd HH:mm:ss
     * @param pageIndex 页码
     * @param pageSize 每页记录数，取值范围: 1~1000
     * @return
     */
    @GetMapping(value = "/getStandard")
    public AjaxResult getStandard (@RequestParam(value = "updateTime") String updateTime,@RequestParam(value = "pageIndex") Integer pageIndex,@RequestParam(value = "pageSize") Integer pageSize){
        try {
            Map<String,Object> map = new HashMap<>();
            map.put("updateTime",updateTime);
            map.put("pageIndex",pageIndex);
            map.put("pageSize",pageSize);
            JSONObject json = governmentSupervisionInfoService.getStandard(map);
            return AjaxResult.success(json);
        } catch (Exception e) {
            log.error("获取隐患分类分级标准失败",e);
            return AjaxResult.error("获取隐患分类分级标准失败");
        }
    }


}
