package com.zehong.web.controller.gasBottleTrack;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TGasBottleInfo;
import com.zehong.system.domain.TGasBottleTrackRecord;
import com.zehong.system.domain.TTaskRecord;
import com.zehong.system.service.ITGasBottleInfoService;
import com.zehong.system.service.ITGasBottleTrackRecordService;
import com.zehong.system.service.ITTaskRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

/**
 * 气瓶追溯Controller
 *
 * @author zehong
 * @date 2023-08-18
 */
@RestController
@RequestMapping("/track/record")
public class TGasBottleTrackRecordController extends BaseController
{
    @Autowired
    private ITGasBottleTrackRecordService tGasBottleTrackRecordService;
    @Autowired
    private ITGasBottleInfoService tGasBottleInfoService;

    @Autowired
    private ITTaskRecordService tTaskRecordService;
    /**
     * 查询气瓶追溯列表
     */
    @RequestMapping("/list")
    public TableDataInfo list(TGasBottleTrackRecord tGasBottleTrackRecord)
    {
        startPage();
        List<TGasBottleTrackRecord> list = tGasBottleTrackRecordService.selectTGasBottleTrackRecordList(tGasBottleTrackRecord);
        return getDataTable(list);
    }



    /**
     * 微信小程序 获取回收记录详细信息
     * @param trackRecordId
     * @return
     */
    @GetMapping("/selectGet")
    public AjaxResult selectGetInfo(Long trackRecordId){
        TGasBottleTrackRecord tGasBottleTrackRecord = tGasBottleTrackRecordService.selectTGasBottleTrackRecordById(trackRecordId);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("tGasBottleTrackRecord", tGasBottleTrackRecord);
        return ajax;
    }


    /**
     * 微信小程序 气瓶追溯信息查询
     * @param tGasBottleTrackRecord
     * @return
     */
    @GetMapping("/gasCylinderTraceability")
    public TableDataInfo gasCylinderTraceability(TGasBottleTrackRecord tGasBottleTrackRecord)
    {
        startPage();
        List<TGasBottleTrackRecord> list = tGasBottleTrackRecordService.selectTGasBottleTrackRecordList(tGasBottleTrackRecord);
        return getDataTable(list);
    }

    @PostMapping("/bottleTrackRecordList")
    public AjaxResult bottleTrackRecordList(@RequestBody TGasBottleTrackRecord tGasBottleTrackRecord)
    {
        List<TGasBottleTrackRecord> list = tGasBottleTrackRecordService.selectTGasBottleTrackRecordList(tGasBottleTrackRecord);
        return AjaxResult.success(list);
    }

    /**
     * 导出气瓶追溯列表
     */
    @Log(title = "气瓶追溯", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public AjaxResult export(@RequestBody TGasBottleTrackRecord tGasBottleTrackRecord)
    {
        List<TGasBottleTrackRecord> list = tGasBottleTrackRecordService.selectTGasBottleTrackRecordList(tGasBottleTrackRecord);
        ExcelUtil<TGasBottleTrackRecord> util = new ExcelUtil<TGasBottleTrackRecord>(TGasBottleTrackRecord.class);
        return util.exportExcel(list, "气瓶追溯数据");
    }

    /**
     * 获取气瓶追溯详细信息
     */
    @GetMapping(value = "/{trackRecordId}")
    public AjaxResult getInfo(@PathVariable("trackRecordId") Long trackRecordId)
    {
        return AjaxResult.success(tGasBottleTrackRecordService.selectTGasBottleTrackRecordById(trackRecordId));
    }

    /**
     * 新增气瓶追溯
     */
    @Log(title = "气瓶追溯", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TGasBottleTrackRecord tGasBottleTrackRecord)
    {
        return toAjax(tGasBottleTrackRecordService.insertTGasBottleTrackRecord(tGasBottleTrackRecord));
    }


    /**
     * 气瓶回收信息添加
     * @param tGasBottleTrackRecord
     * @return
     */
    @PostMapping("/addTGasBottleTrackRecord")
    public int addTGasBottleTrackRecord(@RequestBody TGasBottleTrackRecord tGasBottleTrackRecord) throws ParseException {
        TGasBottleInfo tGasBottleInfo1 = tGasBottleInfoService.selectTGasBottleInfoById(tGasBottleTrackRecord.getBottleId());
        if ("0".equals(tGasBottleInfo1.getCurrentStatus())){
            return 0;
        }
        //修改气瓶状态
        TGasBottleInfo tGasBottleInfo=new TGasBottleInfo();
        tGasBottleInfo.setBottleId(tGasBottleTrackRecord.getBottleId());
        //设置气瓶为在站状态
        tGasBottleInfo.setCurrentStatus("0");
        //设置气瓶为空瓶状态
        tGasBottleInfo.setEmptyType("0");
        tGasBottleInfoService.updateTGasBottleInfo(tGasBottleInfo);

//        DateFormat fmt =new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        Date date = fmt.parse(tGasBottleTrackRecord.getOperateDates());
        //气瓶追溯信息添加
        tGasBottleTrackRecord.setOperateDate(new Date());
        tGasBottleTrackRecordService.insertTGasBottleTrackRecord(tGasBottleTrackRecord);

        //设置任务记录信息
        TTaskRecord tTaskRecord=new TTaskRecord();
        //操作人id
        tTaskRecord.setOperator(Long.valueOf(tGasBottleTrackRecord.getOperator()));
        //工序
        tTaskRecord.setProcessesName("3");
        tTaskRecord.setCreateTime(new Date());
        tTaskRecord.setProcessesRelationId(tGasBottleTrackRecord.getTrackRecordId());
        //任务记录表信息添加
        tTaskRecordService.insertTTaskRecord(tTaskRecord);
        return 1;
    }


    /**
     * 修改气瓶追溯
     */
    @Log(title = "气瓶追溯", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TGasBottleTrackRecord tGasBottleTrackRecord)
    {
        return toAjax(tGasBottleTrackRecordService.updateTGasBottleTrackRecord(tGasBottleTrackRecord));
    }

    /**
     * 删除气瓶追溯
     */
    @Log(title = "气瓶追溯", businessType = BusinessType.DELETE)
	@DeleteMapping("/{trackRecordIds}")
    public AjaxResult remove(@PathVariable Long[] trackRecordIds)
    {
        return toAjax(tGasBottleTrackRecordService.deleteTGasBottleTrackRecordByIds(trackRecordIds));
    }
}
