package com.zehong.web.controller.complainDeal;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TComplainDealTransfer;
import com.zehong.system.service.ITComplainDealTransferService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 燃气投诉处置-转办记录Controller
 * 
 * @author zehong
 * @date 2024-06-06
 */
@RestController
@RequestMapping("/complainDeal/transfer")
public class TComplainDealTransferController extends BaseController
{
    @Autowired
    private ITComplainDealTransferService tComplainDealTransferService;

    /**
     * 查询燃气投诉处置-转办记录列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TComplainDealTransfer tComplainDealTransfer)
    {
        startPage();
        List<TComplainDealTransfer> list = tComplainDealTransferService.selectTComplainDealTransferList(tComplainDealTransfer);
        return getDataTable(list);
    }

    /**
     * 导出燃气投诉处置-转办记录列表
     */
    @Log(title = "燃气投诉处置-转办记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TComplainDealTransfer tComplainDealTransfer)
    {
        List<TComplainDealTransfer> list = tComplainDealTransferService.selectTComplainDealTransferList(tComplainDealTransfer);
        ExcelUtil<TComplainDealTransfer> util = new ExcelUtil<TComplainDealTransfer>(TComplainDealTransfer.class);
        return util.exportExcel(list, "燃气投诉处置-转办记录数据");
    }

    /**
     * 获取燃气投诉处置-转办记录详细信息-根据 投诉处置id查
     */
    @GetMapping(value = "/{complainDealTransferId}")
    public AjaxResult getInfo(@PathVariable("complainDealTransferId") Long complainDealTransferId)
    {
        return AjaxResult.success(tComplainDealTransferService.selectTComplainDealTransferById(complainDealTransferId));
    }

    /**
     * 获取燃气投诉处置-转办记录详细信息-根据 投诉处置id查
     */
    @GetMapping(value = "/queryByComplainDealId/{complainDealId}")
    public AjaxResult queryComplainDealTransferListByComplainDealId(@PathVariable("complainDealId") Long complainDealId)
    {
        return AjaxResult.success(tComplainDealTransferService.queryComplainDealTransferListByComplainDealId(complainDealId));
    }


    /**
     * 新增燃气投诉处置-转办记录
     */
    @Log(title = "燃气投诉处置-转办记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TComplainDealTransfer tComplainDealTransfer)
    {
        return  tComplainDealTransferService.insertTComplainDealTransfer(tComplainDealTransfer);
    }

    /**
     * 修改燃气投诉处置-转办记录
     */
    @Log(title = "燃气投诉处置-转办记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TComplainDealTransfer tComplainDealTransfer)
    {
        return toAjax(tComplainDealTransferService.updateTComplainDealTransfer(tComplainDealTransfer));
    }

    /**
     * 删除燃气投诉处置-转办记录
     */
    @Log(title = "燃气投诉处置-转办记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{complainDealTransferIds}")
    public AjaxResult remove(@PathVariable Long[] complainDealTransferIds)
    {
        return toAjax(tComplainDealTransferService.deleteTComplainDealTransferByIds(complainDealTransferIds));
    }
}
