import { login, logout, getInfo } from '@/api/login'
import { getToken, setToken, removeToken } from '@/utils/auth'

const user = {
  state: {
    token: getToken(),
    name: '',
    avatar: '',
    roles: [],
    permissions: [],
    systemSetting:{},
    posts: [],
    enterpriseId: '',
    userId: '',
    roleId: '',
    enterpriseName:'',
  },

  mutations: {
    SET_TOKEN: (state, token) => {
      state.token = token
    },
    SET_NAME: (state, name) => {
      state.name = name
    },
    SET_AVATAR: (state, avatar) => {
      state.avatar = avatar
    },
    SET_ROLES: (state, roles) => {
      state.roles = roles
    },
    SET_PERMISSIONS: (state, permissions) => {
      state.permissions = permissions
    },
    SET_SYSTEMSETTING: (state, systemSetting) => {
      state.systemSetting = systemSetting
    },
    SET_POSTS: (state, posts) => {
      state.posts = posts
    },
    SET_ENTERPRISEID: (state,enterpriseId) =>{
      state.enterpriseId = enterpriseId
    },
    SET_ENTERPRISENAME:(state,enterpriseName) =>{
      state.enterpriseName = enterpriseName
    },
    SET_USERID:(state,userId) =>{
      state.userId = userId
    },
    SET_ROLEID:(state,roleId) =>{
      state.roleId = roleId
    },
  },

  actions: {
    // 登录
    Login({ commit }, userInfo) {
      const username = userInfo.username.trim()
      const password = userInfo.password
      const code = userInfo.code
      const uuid = userInfo.uuid
      return new Promise((resolve, reject) => {
        login(username, password, code, uuid).then(res => {
          setToken(res.token)
          commit('SET_TOKEN', res.token)
          resolve()
        }).catch(error => {
          reject(error)
        })
      })
    },
    // 获取用户信息
    GetInfo({ commit, state,dispatch}) {
      return new Promise((resolve, reject) => {
        getInfo().then(res => {
          const user = res.user
          const avatar = user.avatar == "" ? require("@/assets/images/profile.jpg") : process.env.VUE_APP_BASE_API + user.avatar;
          console.log("getInfo")
          if (res.roles && res.roles.length > 0) { // 验证返回的roles是否是一个非空数组
            commit('SET_ROLES', res.roles)
            commit('SET_PERMISSIONS', res.permissions)
          } else {
            commit('SET_ROLES', ['ROLE_DEFAULT'])
          }
          commit('SET_NAME', user.userName)
          commit('SET_AVATAR', avatar)
          // 默认配置
          commit('SET_SYSTEMSETTING', res.systemSetting)
          commit('SET_POSTS',res.posts)
          commit('SET_ENTERPRISEID',user.deptId)
          commit('SET_USERID',user.userId);
          commit('SET_ROLEID',user.roles[0].roleId);
          commit('SET_ENTERPRISENAME',user.enterpriseName);
          // 大屏公司获取
          // 第一个参数是其他模块的 actions 路径,
          // 第二个是传给 actions 的数据, 如果不需要传数据, 也必须预留,
          // 第三个参数是配置选项, 申明这个 acitons 不是当前模块的
          dispatch("bigWindowCompany/GetCompany",{},{root:true})
         console.log(res.systemSetting)
          resolve(res)
        }).catch(error => {
          reject(error)
        })
      })
    },

    // 退出系统
    LogOut({ commit, state }) {
      return new Promise((resolve, reject) => {
        logout(state.token).then(() => {
          commit('SET_TOKEN', '')
          commit('SET_ROLES', [])
          commit('SET_PERMISSIONS', [])
          removeToken()
          resolve()
        }).catch(error => {
          reject(error)
        })
      })
    },

    // 前端 登出
    FedLogOut({ commit }) {
      return new Promise(resolve => {
        commit('SET_TOKEN', '')
        removeToken()
        resolve()
      })
    }
  }
}

export default user
