/*
 * @Author: 纪泽龙 jizelong@qq.com
 * @Date: 2024-07-15 10:26:41
 * @LastEditors: 纪泽龙 jizelong@qq.com
 * @LastEditTime: 2025-09-16 11:24:41
 * @FilePath: /zh-baseversion-web/src/permission.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import router from "./router";
import store from "./store";
import { Message } from "element-ui";
import NProgress from "nprogress";
import "nprogress/nprogress.css";
import { getToken } from "@/utils/auth";

NProgress.configure({ showSpinner: false });

const whiteList = [
  "/login",
  "/auth-redirect",
  "/bind",
  "/register",
  "/outindex",
];

// 路由前置守卫
router.beforeEach((to, from, next) => {
  NProgress.start();
  // 如果cookie里有token
  if (getToken()) {
    /* has token*/
    // 如果要去login，就直接去默认页面
    if (to.path === "/login") {
      next({ path: "/" });
      NProgress.done();
    } else {
      console.log("有");
      // 动态添加地图跟可视化线条的script
      var url1 =
        "https://webapi.amap.com/maps?v=2.0&key=49fcb156d466062435d7d33437099582&plugin=Map3D,AMap.DistrictSearch,AMap.Scale,AMap.OverView,AMap.ToolBar,AMap.MouseTool,AMap.ControlBar,AMap.CircleEditor,AMap.PolyEditor";
      let url2 =
        "https://webapi.amap.com/loca?v=2.0.0&key=49fcb156d466062435d7d33437099582";

      let jsapi;
      if (!document.querySelector(".mapSrcipt1")) {
        jsapi = document.createElement("script");
        jsapi.charset = "utf-8";
        jsapi.className = "mapSrcipt1";

        jsapi.src = url1;
        document.head.appendChild(jsapi);
      }
      if (!document.querySelector(".mapSrcipt2")) {
        jsapi = document.createElement("script");
        jsapi.charset = "utf-8";
        jsapi.className = "mapSrcipt2";

        jsapi.src = url2;
        document.head.appendChild(jsapi);
      }

      // 如果没有获得当前用户的所有信息
      if (store.getters.roles.length === 0) {
        // 判断当前用户是否已拉取完user_info信息
        store
          .dispatch("GetInfo")
          .then(() => {
            // 生成路有树
            store.dispatch("GenerateRoutes").then((accessRoutes) => {
              // 根据roles权限生成可访问的路由表
              router.addRoutes(accessRoutes); // 动态添加可访问路由表
              next({ ...to, replace: true }); // hack方法 确保addRoutes已完成
            });
          })
          .catch((err) => {
            store.dispatch("LogOut").then(() => {
              Message.error(err);
              next({ path: "/" });
            });
          });
      } else {
        next();
        // // 判断各种浏览器，找到正确的方法
        // function launchFullscreen(element) {
        //   if (element.requestFullscreen) {
        //     element.requestFullscreen();
        //   } else if (element.mozRequestFullScreen) {
        //     element.mozRequestFullScreen();
        //   } else if (element.webkitRequestFullscreen) {
        //     element.webkitRequestFullscreen();
        //   } else if (element.msRequestFullscreen) {
        //     element.msRequestFullscreen();
        //   }
        // }
        // launchFullscreen(document.documentElement)
      }
    }
  } else {
    // 没有token
    if (whiteList.indexOf(to.path) !== -1) {
      // 在免登录白名单，直接进入
      next();
    } else {
      next(`/login?redirect=${to.fullPath}`); // 否则全部重定向到登录页
      NProgress.done();
    }
  }
});

router.afterEach(() => {
  NProgress.done();
});
