import request from '@/utils/request'

// 查询调岗记录列表
export function listRecord(query) {
  return request({
    url: '/transferPost/record/list',
    method: 'get',
    params: query
  })
}

// 查询调岗记录详细
export function getRecord(recordId) {
  return request({
    url: '/transferPost/record/' + recordId,
    method: 'get'
  })
}

// 新增调岗记录
export function addRecord(data) {
  return request({
    url: '/transferPost/record',
    method: 'post',
    data: data
  })
}

// 修改调岗记录
export function updateRecord(data) {
  return request({
    url: '/transferPost/record',
    method: 'put',
    data: data
  })
}

// 删除调岗记录
export function delRecord(recordId) {
  return request({
    url: '/transferPost/record/' + recordId,
    method: 'delete'
  })
}

// 导出调岗记录
export function exportRecord(query) {
  return request({
    url: '/transferPost/record/export',
    method: 'get',
    params: query
  })
}
