import request from '@/utils/request'

// 查询供需平衡-停气监管-停气进度操作历史记录列表
export function listLog(query) {
  return request({
    url: '/supplyBalance/stopLog/list',
    method: 'get',
    params: query
  })
}

// 查询供需平衡-停气监管-停气进度操作历史记录详细
export function getLog(fOprPressLogId) {
  return request({
    url: '/supplyBalance/stopLog/' + fOprPressLogId,
    method: 'get'
  })
}

// 新增供需平衡-停气监管-停气进度操作历史记录
export function addLog(data) {
  return request({
    url: '/supplyBalance/stopLog',
    method: 'post',
    data: data
  })
}

// 修改供需平衡-停气监管-停气进度操作历史记录
export function updateLog(data) {
  return request({
    url: '/supplyBalance/stopLog',
    method: 'put',
    data: data
  })
}

// 删除供需平衡-停气监管-停气进度操作历史记录
export function delLog(fOprPressLogId) {
  return request({
    url: '/supplyBalance/stopLog/' + fOprPressLogId,
    method: 'delete'
  })
}

// 导出供需平衡-停气监管-停气进度操作历史记录
export function exportLog(query) {
  return request({
    url: '/supplyBalance/stopLog/export',
    method: 'get',
    params: query
  })
}
