import request from '@/utils/request'

// 查询供需平衡-停气监管列表
export function listSup(query) {
  return request({
    url: '/supplyBalance/stop/list',
    method: 'get',
    params: query
  })
}

// 查询供需平衡-停气监管详细
export function getSup(fGasStopId) {
  return request({
    url: '/supplyBalance/stop/' + fGasStopId,
    method: 'get'
  })
}

// 新增供需平衡-停气监管
export function addSup(data) {
  return request({
    url: '/supplyBalance/stop',
    method: 'post',
    data: data
  })
}

// 修改供需平衡-停气监管
export function updateSup(data) {
  return request({
    url: '/supplyBalance/stop',
    method: 'put',
    data: data
  })
}

// 删除供需平衡-停气监管
export function delSup(fGasStopId) {
  return request({
    url: '/supplyBalance/stop/' + fGasStopId,
    method: 'delete'
  })
}

// 导出供需平衡-停气监管
export function exportSup(query) {
  return request({
    url: '/supplyBalance/stop/export',
    method: 'get',
    params: query
  })
}

//改变停气状态
export function changeStopStatus(data) {
  return request({
    url: '/supplyBalance/stop/changeStopStatus',
    method: 'post',
    data: data
  })
}
