import request from '@/utils/request'

// 查询供需平衡-企业每日填报列表
export function listDay(query) {
  return request({
    url: '/supplyBalance/day/list',
    method: 'get',
    params: query
  })
}

// 查询供需平衡-企业每日填报详细
export function getDay(fRepUsgDayId) {
  return request({
    url: '/supplyBalance/day/' + fRepUsgDayId,
    method: 'get'
  })
}

// 新增供需平衡-企业每日填报
export function addDay(data) {
  return request({
    url: '/supplyBalance/day',
    method: 'post',
    data: data
  })
}

// 修改供需平衡-企业每日填报
export function updateDay(data) {
  return request({
    url: '/supplyBalance/day',
    method: 'put',
    data: data
  })
}

// 删除供需平衡-企业每日填报
export function delDay(fRepUsgDayId) {
  return request({
    url: '/supplyBalance/day/' + fRepUsgDayId,
    method: 'delete'
  })
}

// 导出供需平衡-企业每日填报
export function exportDay(query) {
  return request({
    url: '/supplyBalance/day/export',
    method: 'get',
    params: query
  })
}

export function reportInfoList(query) {
  return request({
    url: '/supplyBalance/day/reportInfoList',
    method: 'get',
    params: query
  })
}

export function getReportInfoByCompany(query) {
  return request({
    url: '/supplyBalance/day/getReportInfoByCompany',
    method: 'get',
    params: query
  })
}

export function reportSupBalGasDayRecInfo(query) {
  return request({
    url: '/supplyBalance/day/reportSupBalGasDayRecInfo',
    method: 'get',
    params: query
  })
}
