import request from '@/utils/request'

// 查询监督检查-调查结果列表
export function listInfor(query) {
  return request({
    url: '/supervision/findings/list',
    method: 'get',
    params: query
  })
}

// 查询监督检查-调查结果详细
export function getInfor(fInsSpotRecInforId) {
  return request({
    url: '/supervision/findings/' + fInsSpotRecInforId,
    method: 'get'
  })
}

// 新增监督检查-调查结果
export function addInfor(data) {
  return request({
    url: '/supervision/findings',
    method: 'post',
    data: data
  })
}

// 修改监督检查-调查结果
export function updateInfor(data) {
  return request({
    url: '/supervision/findings',
    method: 'put',
    data: data
  })
}

// 删除监督检查-调查结果
export function delInfor(fInsSpotRecInforId) {
  return request({
    url: '/supervision/findings/' + fInsSpotRecInforId,
    method: 'delete'
  })
}

// 导出监督检查-调查结果
export function exportInfor(query) {
  return request({
    url: '/supervision/findings/export',
    method: 'get',
    params: query
  })
}

// 导出监督检查-调查结果
export function reportSpotRecInfo(query) {
  return request({
    url: '/supervision/findings/reportSpotRecInfo',
    method: 'get',
    params: query
  })
}
