import request from '@/utils/request'

// 查询入户安检结果列表
export function listReport(query) {
  return request({
    url: '/supervise/report/list',
    method: 'get',
    params: query
  })
}

// 查询入户安检结果列表
export function summarylist(query) {
  return request({
    url: '/supervise/report/summarylist',
    method: 'get',
    params: query
  })
}


// 查询入户安检结果详细
export function getReport(reportId) {
  return request({
    url: '/supervise/report/' + reportId,
    method: 'get'
  })
}

// 新增入户安检结果
export function addReport(data) {
  return request({
    url: '/supervise/report',
    method: 'post',
    data: data
  })
}

// 修改入户安检结果
export function updateReport(data) {
  return request({
    url: '/supervise/report',
    method: 'put',
    data: data
  })
}

// 删除入户安检结果
export function delReport(reportId) {
  return request({
    url: '/supervise/report/' + reportId,
    method: 'delete'
  })
}

// 导出入户安检结果
export function exportReport(query) {
  return request({
    url: '/supervise/report/export',
    method: 'get',
    params: query
  })
}
