import request from '@/utils/request'

// 查询巡线人员管理列表
export function listPerson(query) {
  return request({
    url: '/linePatrol/person/list',
    method: 'get',
    params: query
  })
}

export function linePatrolPersonList(query) {
  return request({
    url: '/linePatrol/person/linePatrolPersonList',
    method: 'get',
    params: query
  })
}

// 查询巡线人员管理详细
export function getPerson(personId) {
  return request({
    url: '/linePatrol/person/' + personId,
    method: 'get'
  })
}

// 新增巡线人员管理
export function addPerson(data) {
  return request({
    url: '/linePatrol/person',
    method: 'post',
    data: data
  })
}

// 修改巡线人员管理
export function updatePerson(data) {
  return request({
    url: '/linePatrol/person',
    method: 'put',
    data: data
  })
}

// 删除巡线人员管理
export function delPerson(personId) {
  return request({
    url: '/linePatrol/person/' + personId,
    method: 'delete'
  })
}

// 导出巡线人员管理
export function exportPerson(query) {
  return request({
    url: '/linePatrol/person/export',
    method: 'get',
    params: query
  })
}
