import request from '@/utils/request'

// 查询燃气督办列表
export function listSupervisorInfo(query) {
  return request({
    url: '/supervisor/info/list',
    method: 'get',
    params: query
  })
}

// 查询燃气督办list
export function supervisorInfoList(query) {
  return request({
    url: '/supervisor/info/supervisorInfoList',
    method: 'get',
    params: query
  })
}

// 查询燃气督办详细
export function getSupervisorInfo(supervisorId) {
  return request({
    url: '/supervisor/info/' + supervisorId,
    method: 'get'
  })
}

// 新增燃气督办
export function addSupervisorInfo(data) {
  return request({
    url: '/supervisor/info',
    method: 'post',
    data: data
  })
}

// 修改燃气督办
export function updateSupervisorInfo(data) {
  return request({
    url: '/supervisor/info',
    method: 'put',
    data: data
  })
}

// 删除燃气督办
export function delSupervisorInfo(supervisorId) {
  return request({
    url: '/supervisor/info/' + supervisorId,
    method: 'delete'
  })
}

// 导出燃气督办
export function exportSupervisorInfo(query) {
  return request({
    url: '/supervisor/info/export',
    method: 'get',
    params: query
  })
}
