import request from '@/utils/request'

// 查询液化石油车辆信息列表
export function listInfo(query) {
  return request({
    url: '/lpg/vehicleInfo/list',
    method: 'get',
    params: query
  })
}

// 查询液化石油车辆信息详细
export function getInfo(vehicleId) {
  return request({
    url: '/lpg/vehicleInfo/' + vehicleId,
    method: 'get'
  })
}

// 新增液化石油车辆信息
export function addInfo(data) {
  return request({
    url: '/lpg/vehicleInfo',
    method: 'post',
    data: data
  })
}

// 修改液化石油车辆信息
export function updateInfo(data) {
  return request({
    url: '/lpg/vehicleInfo',
    method: 'put',
    data: data
  })
}

// 删除液化石油车辆信息
export function delInfo(vehicleId) {
  return request({
    url: '/lpg/vehicleInfo/' + vehicleId,
    method: 'delete'
  })
}

// 导出液化石油车辆信息
export function exportInfo(query) {
  return request({
    url: '/lpg/vehicleInfo/export',
    method: 'get',
    params: query
  })
}

// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/lpg/vehicleInfo/importTemplate',
    method: 'get'
  })
}