import request from '@/utils/request'

// 查询燃气用户列表
export function listUser(query) {
  return request({
    url: '/system/yehuaqiUser/list',
    method: 'get',
    params: query
  })
}

// 查询燃气用户详细ee
export function getUser(userId) {
  return request({
    url: '/system/yehuaqiUser/' + userId,
    method: 'get'
  })
}

// 新增燃气用户
export function addUser(data) {
  return request({
    url: '/system/yehuaqiUser',
    method: 'post',
    data: data
  })
}

// 修改燃气用户
export function updateUser(data) {
  return request({
    url: '/system/yehuaqiUser',
    method: 'put',
    data: data
  })
}

// 删除燃气用户
export function delUser(userId) {
  return request({
    url: '/system/yehuaqiUser/' + userId,
    method: 'delete'
  })
}

// 导出燃气用户
export function exportUser(query) {
  return request({
    url: '/system/yehuaqiUser/export',
    method: 'get',
    params: query
  })
}


// 导出燃气用户-新的-有居住区的导出
export function newExportUser(query) {
  return request({
    url: '/system/yehuaqiUser/newExport',
    method: 'get',
    params: query
  })
}


// 查询 安装加装装置数据
export function getNoSelectSafetyDetailInfo(data) {
  return request({
    url: '/gasUserSafetyDevice/info/queryNoSelectSafeDeviceInfoList',
    method: 'post',
    data: data
  })
}



// 查询 安装加装装置数据
export function addSafetyDetailInfo(data) {
  return request({
    url: '/gasUserSafetyDevice/info',
    method: 'post',
    data: data
  })
}


// 关联安装加装装置 批量删除
export function deleteSafetyDeviceListInfo(data) {
  return request({
    url: '/gasUserSafetyDevice/info/deleteSafetyDeviceListInfo',
    method: 'post',
    data: data
  })
}

// 删除关联设备信息
export function deleteSafetyDeviceInfo(deviceId) {
  return request({
    url: '/yehuaqiUserSafetyDeviceInfo/info/deleteTYehuaqiuserSafetyDeviceInfoById/' + deviceId,
    method: 'delete'
  })
}

// 根据燃气用户id 查询 关联 安全装置加装
export function queryDeviceInfoByUserId(userId) {
  return request({
    url: '/yehuaqiUserSafetyDeviceInfo/info/queryDeviceInfoByUserId/'+ userId,
    method: 'get'
  })
}



// 新增燃气用户-包含安全装置
export function addUserAndSafetyDevice(data) {
  return request({
    url: '/system/yehuaqiUser/addUserAndSafetyDevice',
    method: 'post',
    data: data
  })
}

// 修改燃气用户-包含安全装置
export function updateUserAndSafetyDevice(data) {
  return request({
    url: '/system/yehuaqiUser/updateUserAndSafetyDevice',
    method: 'post',
    data: data
  })
}



// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/system/yehuaqiUser/importTemplate',
    method: 'get'
  })
}


// 下载用户导入模板 - 自定义的模版
export function downloadTemplate() {
  return request({
    url: '/system/yehuaqiUser/downloadTemplate',
    method: 'get',
    responseType: 'blob'
  })
}


// 统计错误数量
export function countImportError() {
  return request({
    url: '/system/yehuaqiUser/countImportError',
    method: 'get'
  })
}

// 清除错误数据
export function clearImportError() {
  return request({
    url: '/system/yehuaqiUser/clearImportError',
    method: 'get'
  })
}


// 导出从业人员信息- 错误数据
export function exportErrorData() {
  return request({
    url: '/system/yehuaqiUser/exportErrorData',
    method: 'get',
    responseType: 'blob'
  })
}

//自定义-模版下载-正确数据导出-燃气用户
export function exportSuccessData(query) {
  return request({
    url: '/system/yehuaqiUser/exportSuccessData',
    method: 'get',
    responseType: 'blob',
    params: query
  })
}